package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;

public class UserSimpleEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    @Length(max = 64, message = "长度需要大于0且小于64")
    private String name;

    @Length(max = 64, message = "长度需要大于0且小于64")
    private String realName;

    @Length(max = 11, message = "长度需要大于0且小于11")
    private String mobile;

    private String accId;//云信id

    //头像
    private String headImgURL;
    //全身像
    private String fullImgURL;

    private String description;

    private String hotlinephone;
    private String enabled;
    private String cornet;

    public String getHotlinephone() {
        return hotlinephone;
    }

    public void setHotlinephone(String hotlinephone) {
        this.hotlinephone = hotlinephone;
    }

    public String getEnabled() {
        return enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    public String getCornet() {
        return cornet;
    }

    public void setCornet(String cornet) {
        this.cornet = cornet;
    }

    private Integer seeCount;    //带看次数

    //评价分
    private BigDecimal score;

    private String goodat;

    public Integer getSeeCount() {
        return seeCount;
    }

    public void setSeeCount(Integer seeCount) {
        this.seeCount = seeCount;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public String getGoodat() {
        return goodat;
    }

    public void setGoodat(String goodat) {
        this.goodat = goodat;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getAccId() {
        return accId;
    }

    public void setAccId(String accId) {
        this.accId = accId;
    }

    public String getHeadImgURL() {
        return headImgURL;
    }

    public void setHeadImgURL(String headImgURL) {
        this.headImgURL = headImgURL;
    }

    public String getFullImgURL() {
        return fullImgURL;
    }

    public void setFullImgURL(String fullImgURL) {
        this.fullImgURL = fullImgURL;
    }
}
