/**
 * Description: 统计信息数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-27 下午 15:54:06
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-27   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * 统计信息数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-27
 * @see
 * @since 1.0
 */
public class StatisticEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 报表序号 1-4
     */
    @NotNull
    private Integer sort;

    /**
     * name
     */
    @NotBlank
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String name;

    /**
     * group
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String group;

    /**
     * 业绩
     */
    @NotNull
    private java.math.BigDecimal performance;

    /**
     * 认购宗数
     */
    @NotNull
    private Integer buyNum;

    /**
     * createTime
     */
    @NotNull
    private java.util.Date createTime;

    /**
     * creater
     */
    @NotBlank
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * reportName
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String reportName;

    //代表城市的部门ID
    private String deptCityId;

    private String filePath;

    private String fileName;

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getDeptCityId() {
        return deptCityId;
    }

    public void setDeptCityId(String deptCityId) {
        this.deptCityId = deptCityId;
    }

    /**
     * 设置报表序号 1-4
     *
     * @param sort 报表序号 1-4
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    /**
     * 获取报表序号 1-4
     *
     * @return 报表序号 1-4
     */
    public Integer getSort() {
        return this.sort;
    }

    /**
     * 设置name
     *
     * @param name name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取name
     *
     * @return name
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置group
     *
     * @param group group
     */
    public void setGroup(String group) {
        this.group = group;
    }

    /**
     * 获取group
     *
     * @return group
     */
    public String getGroup() {
        return this.group;
    }

    /**
     * 设置业绩
     *
     * @param performance 业绩
     */
    public void setPerformance(java.math.BigDecimal performance) {
        this.performance = performance;
    }

    /**
     * 获取业绩
     *
     * @return 业绩
     */
    public java.math.BigDecimal getPerformance() {
        return this.performance;
    }

    /**
     * 设置认购宗数
     *
     * @param buyNum 认购宗数
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    /**
     * 获取认购宗数
     *
     * @return 认购宗数
     */
    public Integer getBuyNum() {
        return this.buyNum;
    }

    /**
     * 设置createTime
     *
     * @param createTime createTime
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置createTime字符串格式
     *
     * @param createTime createTime
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取createTime
     *
     * @return createTime
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置creater
     *
     * @param creater creater
     */
    public void setCreater(String creater) {
        this.creater = creater;
    }

    /**
     * 获取creater
     *
     * @return creater
     */
    public String getCreater() {
        return this.creater;
    }

    /**
     * 设置reportName
     *
     * @param reportName reportName
     */
    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    /**
     * 获取reportName
     *
     * @return reportName
     */
    public String getReportName() {
        return this.reportName;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("Sort",
                getSort()).append(
                "Name", getName()).append("Group", getGroup()).append("Performance", getPerformance()).append("BuyNum",
                getBuyNum()).append(
                "CreateTime", getCreateTime()).append("Creater", getCreater()).append("ReportName",
                getReportName()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StatisticEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        StatisticEntity other = (StatisticEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

