/**
 * Description: ReportChannel数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 上午 10:14:16
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

/**
 * ReportChannel数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public class ReportChannelEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 名称
     */
    @NotBlank
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String name;

    /**
     * 1 365
     */
    private Integer channelType;

    /**
     * creater
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * createTime
     */
    private java.util.Date createTime;

    /**
     * lastModifier
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String lastModifier;

    /**
     * upateTime
     */

    private java.util.Date upateTime;

    /**
     * city
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String city;

    /**
     * 1 useable 2 disable 3 delete
     */
    private Integer status;

    //columns END

    /**
     * 设置名称
     *
     * @param name 名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取名称
     *
     * @return 名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置1 365
     *
     * @param channelType 1 365
     */
    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    /**
     * 获取1 365
     *
     * @return 1 365
     */
    public Integer getChannelType() {
        return this.channelType;
    }

    /**
     * 设置creater
     *
     * @param creater creater
     */
    public void setCreater(String creater) {
        this.creater = creater;
    }

    /**
     * 获取creater
     *
     * @return creater
     */
    public String getCreater() {
        return this.creater;
    }

    /**
     * 设置createTime
     *
     * @param createTime createTime
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置createTime字符串格式
     *
     * @param createTime createTime
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取createTime
     *
     * @return createTime
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置lastModifier
     *
     * @param lastModifier lastModifier
     */
    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    /**
     * 获取lastModifier
     *
     * @return lastModifier
     */
    public String getLastModifier() {
        return this.lastModifier;
    }

    /**
     * 设置upateTime
     *
     * @param upateTime upateTime
     */
    public void setUpateTime(java.util.Date upateTime) {
        this.upateTime = upateTime;
    }

    /**
     * 设置upateTime字符串格式
     *
     * @param upateTime upateTime
     */
    public void setUpateTimeStr(String upateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(upateTime)) {
            try {
                this.upateTime = java.text.DateFormat.getDateTimeInstance().parse(upateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取upateTime
     *
     * @return upateTime
     */
    public java.util.Date getUpateTime() {
        return this.upateTime;
    }

    /**
     * 设置city
     *
     * @param city city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 获取city
     *
     * @return city
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置1 useable 2 disable
     *
     * @param status 1 useable 2 disable
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取1 useable 2 disable
     *
     * @return 1 useable 2 disable
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("Name",
                getName()).append(
                "ChannelType", getChannelType()).append("Creater", getCreater()).append("CreateTime",
                getCreateTime()).append(
                "LastModifier", getLastModifier()).append("UpateTime", getUpateTime()).append("City", getCity()).append(
                "Status", getStatus()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ReportChannelEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ReportChannelEntity other = (ReportChannelEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

