/**
 * Description: 驻场日报数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 上午 10:14:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * 驻场日报数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public class LocalReportEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 渠道ID
     */
    @NotNull
    private Integer channelId;

    /**
     * 部门ID
     */
    @NotNull
    private Integer departId;

    @NotNull
    private Integer projectId;

    /**
     * 职员ID
     */
    @NotNull
    private Integer userId;

    /**
     * 职员名
     */
    @NotBlank
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String name;

    /**
     * 报备
     */
    private Integer record;

    /**
     * 到访
     */
    private Integer visit;

    /**
     * 认购
     */
    private Integer buy;

    /**
     * 业绩
     */
    private Integer score;

    /**
     * city
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String city;

    /**
     * 预留
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String status;

    /**
     * creater
     */
    @NotBlank
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * createTime
     */
    @NotNull
    private java.util.Date createTime;

    /**
     * lastModifier
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String lastModifier;

    /**
     * updateTime
     */
    private java.util.Date updateTime;

    /**
     * 数据日期
     */
    @NotNull
    private java.util.Date reportDate;

    /**
     * 认筹
     */
    @NotNull
    private Integer buyorder;

    //columns END

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    /**
     * 获取渠道ID
     *
     * @return 渠道ID
     */
    public Integer getChannelId() {
        return this.channelId;
    }

    /**
     * 设置渠道ID
     *
     * @param channelId 渠道ID
     */
    public void setChannelId(Integer channelId) {
        this.channelId = channelId;
    }

    /**
     * 获取部门ID
     *
     * @return 部门ID
     */
    public Integer getDepartId() {
        return this.departId;
    }

    /**
     * 设置部门ID
     *
     * @param departId 部门ID
     */
    public void setDepartId(Integer departId) {
        this.departId = departId;
    }

    /**
     * 获取职员
     *
     * @return 职员
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置职员
     *
     * @param name 职员
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取报备
     *
     * @return 报备
     */
    public Integer getRecord() {
        return this.record;
    }

    /**
     * 设置报备
     *
     * @param record 报备
     */
    public void setRecord(Integer record) {
        this.record = record;
    }

    /**
     * 获取到访
     *
     * @return 到访
     */
    public Integer getVisit() {
        return this.visit;
    }

    /**
     * 设置到访
     *
     * @param visit 到访
     */
    public void setVisit(Integer visit) {
        this.visit = visit;
    }

    /**
     * 获取认购
     *
     * @return 认购
     */
    public Integer getBuy() {
        return this.buy;
    }

    /**
     * 设置认购
     *
     * @param buy 认购
     */
    public void setBuy(Integer buy) {
        this.buy = buy;
    }

    /**
     * 获取业绩
     *
     * @return 业绩
     */
    public Integer getScore() {
        return this.score;
    }

    /**
     * 设置业绩
     *
     * @param score 业绩
     */
    public void setScore(Integer score) {
        this.score = score;
    }

    /**
     * 获取city
     *
     * @return city
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置city
     *
     * @param city city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 获取预留
     *
     * @return 预留
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * 设置预留
     *
     * @param status 预留
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * 获取creater
     *
     * @return creater
     */
    public String getCreater() {
        return this.creater;
    }

    /**
     * 设置creater
     *
     * @param creater creater
     */
    public void setCreater(String creater) {
        this.creater = creater;
    }

    /**
     * 设置createTime字符串格式
     *
     * @param createTime createTime
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取createTime
     *
     * @return createTime
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置createTime
     *
     * @param createTime createTime
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取lastModifier
     *
     * @return lastModifier
     */
    public String getLastModifier() {
        return this.lastModifier;
    }

    /**
     * 设置lastModifier
     *
     * @param lastModifier lastModifier
     */
    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public Integer getProjectId() {
        return projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 设置updateTime字符串格式
     *
     * @param updateTime updateTime
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取updateTime
     *
     * @return updateTime
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置updateTime
     *
     * @param updateTime updateTime
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 设置数据日期字符串格式
     *
     * @param reportDate 数据日期
     */
    public void setReportDateStr(String reportDate) {
        if (!com.house365.web.util.StringUtils.isBlank(reportDate)) {
            try {
                this.reportDate = java.text.DateFormat.getDateTimeInstance().parse(reportDate);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取数据日期
     *
     * @return 数据日期
     */
    public java.util.Date getReportDate() {
        return this.reportDate;
    }

    /**
     * 设置数据日期
     *
     * @param reportDate 数据日期
     */
    public void setReportDate(java.util.Date reportDate) {
        this.reportDate = reportDate;
    }

    /**
     * 获取认筹
     *
     * @return 认筹
     */
    public Integer getBuyorder() {
        return this.buyorder;
    }

    /**
     * 设置认筹
     *
     * @param buyorder 认筹
     */
    public void setBuyorder(Integer buyorder) {
        this.buyorder = buyorder;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("ChannelId",
                getChannelId()).append(
                "DepartId", getDepartId()).append("Name", getName()).append("Record", getRecord()).append("Visit",
                getVisit()).append(
                "Buy", getBuy()).append("Score", getScore()).append("City", getCity()).append("Status", getStatus()).append(
                "Creater", getCreater()).append("CreateTime", getCreateTime()).append("LastModifier",
                getLastModifier()).append(
                "UpdateTime", getUpdateTime()).append("ReportDate", getReportDate()).append("Buyorder",
                getBuyorder()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LocalReportEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LocalReportEntity other = (LocalReportEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

