/**
 * Description: CrmSource数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-12-09 下午 16:02:32
 *
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-09   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * CrmSource数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-09
 * @see
 * @since 1.0
 */
public class CrmSourceEntity extends DomainObject{
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	//可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
	//columns START
	/**
	 * sourceId
	 */
	@NotNull
	private Integer sourceId;

	/**
	 * sourceName
	 */
	@NotBlank @Length(max=128, message="长度需要大于0且小于128")
	private String sourceName;

	/**
	 * status
	 */

	private Integer status;

	/**
	 * categoryId
	 */

	private Integer categoryId;

	/**
	 * categoryName
	 */

	private String categoryName;

	/**
	 * categoryPid
	 */

	private Integer categoryPid;

	/**
	 * createTime
	 */

	private java.util.Date createTime;

	/**
	 * creater
	 */
	@Length(max=45, message="长度需要大于0且小于45")
	private String creater;

	private boolean flag;

	public boolean isFlag() {
		return flag;
	}

	public void setFlag(boolean flag) {
		this.flag = flag;
	}

	//columns END
	/*
	public CrmSource(){
	}

	public CrmSource(
		Integer id
	){
		this.id = id;
	}

    */

	/**
	 * 获取sourceId
	 * @return sourceId
	 */
	public Integer getSourceId() {
		return this.sourceId;
	}

	/**
	 * 设置sourceId
	 * @param sourceId sourceId
	 */
	public void setSourceId(Integer sourceId) {
		this.sourceId = sourceId;
	}

	/**
	 * 获取sourceName
	 * @return sourceName
	 */
	public String getSourceName() {
		return this.sourceName;
	}

	/**
	 * 设置sourceName
	 * @param sourceName sourceName
	 */
	public void setSourceName(String sourceName) {
		this.sourceName = sourceName;
	}

	/**
	 * 获取status
	 * @return status
	 */
	public Integer getStatus() {
		return this.status;
	}

	/**
	 * 设置status
	 * @param status status
	 */
	public void setStatus(Integer status) {
		this.status = status;
	}

	/**
	 * 获取categoryId
	 * @return categoryId
	 */
	public Integer getCategoryId() {
		return this.categoryId;
	}

	/**
	 * 设置categoryId
	 * @param categoryId categoryId
	 */
	public void setCategoryId(Integer categoryId) {
		this.categoryId = categoryId;
	}

	/**
	 * 获取categoryName
	 * @return categoryName
	 */
	public String getCategoryName() {
		return this.categoryName;
	}

	/**
	 * 设置categoryName
	 * @param categoryName categoryName
	 */
	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	/**
	 * 获取categoryPid
	 * @return categoryPid
	 */
	public Integer getCategoryPid() {
		return this.categoryPid;
	}

	/**
	 * 设置categoryPid
	 * @param categoryPid categoryPid
	 */
	public void setCategoryPid(Integer categoryPid) {
		this.categoryPid = categoryPid;
	}

	/**
	 * 设置createTime字符串格式
	 * @param createTime createTime
	 */
	public void setCreateTimeStr(String createTime) {
		if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
			try {
				this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
			} catch (java.text.ParseException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 获取createTime
	 * @return createTime
	 */
	public java.util.Date getCreateTime() {
		return this.createTime;
	}

	/**
	 * 设置createTime
	 * @param createTime createTime
	 */
	public void setCreateTime(java.util.Date createTime) {
		this.createTime = createTime;
	}

	/**
	 * 获取creater
	 * @return creater
	 */
	public String getCreater() {
		return this.creater;
	}

	/**
	 * 设置creater
	 *
	 * @param creater creater
	 */
	public void setCreater(String creater) {
		this.creater = creater;
	}

	/**
	 * 实体的toString方法
	 * @return 实体字符串
	 */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
				.append("Id", getId())
				.append("SourceId", getSourceId())
				.append("SourceName", getSourceName())
				.append("Status", getStatus())
				.append("CategoryId", getCategoryId())
				.append("CategoryName", getCategoryName())
				.append("CategoryPid", getCategoryPid())
				.append("CreateTime", getCreateTime())
				.append("Creater", getCreater())
				.toString();
	}

	/**
	 * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
				.append(getId())
				.toHashCode();
	}

	/**
	 * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof CrmSourceEntity == false) return false;
		if(this == obj) return true;
		CrmSourceEntity other = (CrmSourceEntity)obj;
		return new EqualsBuilder()
				.append(getId(), other.getId())
				.isEquals();
	}
}

