package com.house365.rest.context;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author duhui
 * @version [v1.0.0, 2015年1月24日]
 */
public class ServiceMonitor {

    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger("InterfaceLog");

    private Map<String, IService> servicePool = new HashMap<>();

    public void startMonitorService(String serviceId, IService service) {
        servicePool.put(serviceId, service);
        addServiceMessage(serviceId, "[启动监视]");
    }

    public void stopMonitorService(String serviceId) {
        servicePool.remove(serviceId);
        addServiceMessage(serviceId, "[停止监视]");
    }

    public void addServiceMessage(String serviceId, String message) {
        LOGGER.debug(serviceId + " " + message);
    }
}
