/**
 * Description: 客户项目信息业务接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-15 下午 15:36:18
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.CustomerProjectEntity;
import com.house365.beans.entity.ProjectEntity;
import com.house365.service.system.Interfaces.Service;

import java.io.IOException;
import java.util.Date;

/**
 * 客户项目信息业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public interface ICustomerProjectService<T extends CustomerProjectEntity> extends Service<T> {
    void updateStatus(CustomerProjectEntity customerProjectEntity, Integer status, String updater) throws Exception;

    String postToCRM(CustomerProjectEntity customerProjectEntity, Date date, ProjectEntity project, CustomerEntity customer) throws IOException;

    int checkRepeat(String phone, String pid);

    void updateName(Integer id, String projectName);

}
