/**
 * Description: UserStar业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-05-15 下午 17:04:55
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-05-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.UserStarEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IUserStarDao;
import com.house365.ws.service.interfaces.IUserStarService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * UserStar业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-05-15
 * @see
 * @since 1.0
 */
@Service("userStarService")
public class UserStarServiceImpl<T extends UserStarEntity> extends DefaultServiceImpl<T> implements IUserStarService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IUserStarDao<T> userStarDao;

    @Override
    protected Dao<T> getDao() {
        return userStarDao;
    }
}