/**
 * Description: 角色权限关联业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:21
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.RolePermissionEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.beans.response.RolePermissionListResponse;
import com.house365.ws.dao.interfaces.IRolePermissionDao;
import com.house365.ws.service.interfaces.IRolePermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 角色权限关联业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Service("rolePermissionService")
public class RolePermissionServiceImpl<T extends RolePermissionEntity> extends DefaultServiceImpl<T> implements IRolePermissionService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IRolePermissionDao<T> rolePermissionDao;

    @Override
    protected Dao<T> getDao() {
        return rolePermissionDao;
    }

    @Override
    public RolePermissionListResponse deleteRolePermissionByRoleId(Integer roleId) {
        rolePermissionDao.deleteRolePermissionByRoleId(roleId);
        return null;
    }
}