/**
 * Description: ProjectUser业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 10:05:26
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.ProjectEntity;
import com.house365.beans.entity.ProjectUserEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IProjectUserDao;
import com.house365.ws.service.interfaces.IProjectUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * ProjectUser业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
@Service("projectUserService")
public class ProjectUserServiceImpl<T extends ProjectUserEntity> extends DefaultServiceImpl<T> implements IProjectUserService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IProjectUserDao<T> projectUserDao;

    @Override
    protected Dao<T> getDao() {
        return projectUserDao;
    }

    @Override
    public List<UserEntity> queryUserByPrjId(Integer projectId) {
        return projectUserDao.queryUserByPrjId(projectId);
    }

    @Override
    public List<UserEntity> getProjectUser(List<Integer> projectIds) {
        return projectUserDao.getProjectUser(projectIds);
    }

    @Override
    public List<ProjectEntity> getProjectByUserId(Integer userId, String cityCode) {
        return projectUserDao.getProjectByUserId(userId, cityCode);
    }

    @Override
    public List<ProjectEntity> getProjectByUserId(Integer userId, String cityCode, String showStatus) {
        return projectUserDao.getProjectByUserIdAndStatus(userId, cityCode, showStatus);
    }
}
