package com.house365.ws.service.impl;

import com.house365.beans.entity.BaseAttachment;
import com.house365.beans.entity.ProjectDynamicEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IProjectDynamicDao;
import com.house365.ws.service.interfaces.IProjectDynamicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("projectDynamicService")
public class ProjectDynamicServiceImpl<T extends ProjectDynamicEntity> extends DefaultServiceImpl<T> implements IProjectDynamicService<T> {

    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IProjectDynamicDao<T> projectDynamicDao;

    @Override
    protected Dao<T> getDao() {
        return projectDynamicDao;
    }


    @Override
    public List<BaseAttachment> queryDynamicPicByResouceType(String channel){
        return projectDynamicDao.queryDynamicPicByResouceType(channel);
    }

}
