/**
 * Description: 公告业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-14 下午 17:27:17
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.impl.DefaultServiceImpl;

import com.house365.ws.dao.interfaces.INoticeDao;
import com.house365.ws.service.interfaces.INoticeService;
import com.house365.beans.entity.NoticeEntity;

/**
 * 公告业务实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Service("noticeService")
public class NoticeServiceImpl<T extends NoticeEntity> extends DefaultServiceImpl<T> implements INoticeService<T> {
	/**
	 * 自动注入的数据访问对象
	 */
	@Autowired
	private INoticeDao<T> noticeDao;

    @Override
    protected Dao<T> getDao() {
        return noticeDao;
    }
}