/**
 * Description: 营销活动业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:20:59
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.google.common.base.Strings;
import com.house365.beans.common.HGSConstant;
import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.MarketCustomerEntity;
import com.house365.beans.entity.MarketingActivityEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.web.util.DateTimeUtils;
import com.house365.ws.dao.interfaces.ICustomerDao;
import com.house365.ws.dao.interfaces.IMarketCustomerDao;
import com.house365.ws.dao.interfaces.IMarketingActivityDao;
import com.house365.ws.dao.mapper.CustomerMapper;
import com.house365.ws.dao.mapper.CustomerMergeMapper;
import com.house365.ws.dao.mapper.MarketCustomerMapper;
import com.house365.ws.service.interfaces.ICustomerSourceService;
import com.house365.ws.service.interfaces.IMarketingActivityService;
import com.house365.ws.util.OperateLogUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 营销活动业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
@Service("marketingActivityService")
public class MarketingActivityServiceImpl<T extends MarketingActivityEntity> extends DefaultServiceImpl<T> implements IMarketingActivityService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IMarketingActivityDao<T> marketingActivityDao;

    @Autowired
    private IMarketCustomerDao<MarketCustomerEntity> marketCustomerDao;

    @Autowired
    private ICustomerDao customerDao;

    @Autowired
    private ICustomerSourceService customerSourceService;

    @Autowired
    private OperateLogUtils logUtils;

    @Autowired
    private CustomerMergeMapper customermergemapper;

    @Autowired
    private CustomerMapper customerMapper;

    @Autowired
    private MarketCustomerMapper marketCustomerMapper;

    @Override
    protected Dao<T> getDao() {
        return marketingActivityDao;
    }

    @Override
    public Integer queryCustomerCountByActive(Integer id) {
        return marketingActivityDao.queryCustomerCountByActive(id);
    }

    @Override
    public Integer queryAllPullCount(QueryParams<?> queryParams) {
        return marketingActivityDao.queryAllPullCount(queryParams);
    }

    @Override
    public void setDisable(Integer id) {
        marketingActivityDao.setDisable(id);
    }

    /**
     * 定时清理客户数据回公海并同步更新营销客户数据
     */
    @Override
    public void putOvertimeToOcean() {

        List<MarketCustomerEntity> customerEntities = marketCustomerDao.getOverTimeCustomers();
        for (MarketCustomerEntity mcustomer : customerEntities) {
            Integer id = null;
            CustomerEntity customer = null;
            if (null == mcustomer.getCustomerId()) {
                customer = mcustomer.convertCustomer();
                //更新来源
                Integer sourceId = customerSourceService.updateSource(mcustomer.getCityCode(), mcustomer.getActSource(),
                        mcustomer.getCreateSource(), "CRM");
                customer.setActSourceId(sourceId);
                customer.setCustomerSourceType(HGSConstant.CustomerSourceType.MARKET.getType());
                //删除回公海前的合并客户
                customermergemapper.deleteSingleCustomerMerge(customer);
                //客户回公海
                cleanCustomer(customer);
                id = customerDao.save(customer);
                //添加客户新增日志
                customer.setId(id);
                logUtils.saveCustomerLog(customer, 1, 0, "putOvertimeToOcean定时任务");
                Map<String, Object> map = new HashMap<>(5);
                map.put("id", mcustomer.getId());
                map.put("customerId", id);
                marketCustomerMapper.updateCustomerId(map);
//                mcustomer.setCustomerId(id);
//                //将原有营销客户数据同步更新
//                marketCustomerDao.update(mcustomer);
            } else {
                customer = (CustomerEntity) customerDao.getById(mcustomer.getCustomerId());
                //防止更新不必要的记录,已派工数据不处理，处理活动未结束时回公海的数据
                if (customer != null && (null != customer.getIsDelete() && 1 == customer.getIsDelete())) {
                    if (customer.getManagerId() != null) {
                        int managerId = customer.getManagerId();
                        //删除回公海前的合并客户
                        customermergemapper.deleteSingleCustomerMerge(customer);
                        //客户回公海
                        cleanCustomer(customer);
                        customerDao.update(customer);
                        //添加客户移入公海日志
                        customer.setManagerId(managerId);
                        logUtils.saveCustomerLog(customer, 6, 0, "putOvertimeToOcean定时任务");
                    }
                }
            }
        }
    }

    /**
     * 定时清理客户数据回公海并同步更新营销客户数据
     */
    @Override
    public void putOvertimeWaitCallToOcean() {
        Map<String, Object> searchMap = new HashMap<>(5);
        Date date = new Date();
        date = DateTimeUtils.getUpdateDateTime(date, Calendar.HOUR, -24);
        String startTime = DateTimeUtils.getDateString(date, DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_FULL);
        searchMap.put("date", startTime);
        List<CustomerEntity> list = customerMapper.queryByOverTime(searchMap);
        for (CustomerEntity customer : list) {
            //4.1.0版本需求更改，派工但属于待回访的客户也需要入公海
            if (customer.getIsWaitCall() == 1) {
                int managerId = customer.getManagerId();
                //删除回公海前的合并客户
                customermergemapper.deleteSingleCustomerMerge(customer);
                //客户回公海
                cleanCustomer(customer);
                customerDao.update(customer);
                //添加客户移入公海日志
                customer.setManagerId(managerId);
                logUtils.saveCustomerLog(customer, 6, 0, "putOvertimeWaitCallToOcean");
            }
        }
    }

    private void cleanCustomer(CustomerEntity customer) {
        Date curDate = new Date();
        if (!Strings.isNullOrEmpty(customer.getManagerName())) {
            customer.setLastManager(customer.getManagerName());
        }
        customer.setManagerId(null);
        customer.setIsRecycled(1);
        customer.setManagerName("");
        customer.setUpdateTime(curDate);
        customer.setUpdater("SYSTEM");
        customer.setCreateTime(curDate);
        customer.setCreater("SYSTEM");
        customer.setIsDelete(0);
        //数据公海中客户购房意向为“无效”的客户，如果被派工后，统一提升客户的“购房意向”为：待定
        customer.setBuyIntention("");
    }

    @Override
    public void addCallBackCount(Integer id) {
        marketingActivityDao.addCallBackCount(id);
    }

    @Override
    public void addWaitVisitCount(Integer id) {
        marketingActivityDao.addWaitVisitCount(id);
    }

    @Override
    public void addBughtCount(Integer id) {
        marketingActivityDao.addBughtCount(id);
    }

}
