/**
 * Description: 项目日报-城市部门配置业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-08-09 下午 14:31:30
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-08-09   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.impl.DefaultServiceImpl;

import com.house365.ws.dao.interfaces.ICityDepConfigDao;
import com.house365.ws.service.interfaces.ICityDepConfigService;
import com.house365.beans.entity.CityDepConfigEntity;

/**
 * 项目日报-城市部门配置业务实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-08-09
 * @see
 * @since 1.0
 */
@Service("cityDepConfigService")
public class CityDepConfigServiceImpl<T extends CityDepConfigEntity> extends DefaultServiceImpl<T> implements ICityDepConfigService<T> {
	/**
	 * 自动注入的数据访问对象
	 */
	@Autowired
	private ICityDepConfigDao<T> cityDepConfigDao;

    @Override
    protected Dao<T> getDao() {
        return cityDepConfigDao;
    }
}