package com.house365.ws.service.impl;

import com.house365.beans.entity.BaseAttachment;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IAttachmentDao;
import com.house365.ws.service.interfaces.IAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("attachmentService")
public class AttachmentServiceImpl<T extends BaseAttachment> extends DefaultServiceImpl<T> implements IAttachmentService<T> {

    @Autowired
    IAttachmentDao<T> attachmentDao;

    @Override
    protected Dao<T> getDao() {
        return attachmentDao;
    }

    @Override
    public List<BaseAttachment> getByResourceId(Integer resourceId) {
        return attachmentDao.getByResourceId(resourceId);
    }

    /**
     * 根据resourceId和resouceType查询
     */
    @Override
    public List<BaseAttachment> queryByResourceIdAndResouceType(String resourceId, String channel) {
        return attachmentDao.queryByResourceIdAndResouceType(resourceId, channel);
    }

    @Override
    public List<BaseAttachment> queryByResouceType(String channel){
        return attachmentDao.queryByResouceType(channel);
    }

}
