package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.EvaluateUserCustomerLogEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.beans.response.CustomerResponse;
import com.house365.ws.interfaces.server.IEvaluateUserCustomerLog;
import com.house365.ws.service.interfaces.IEvaluateUserCustomerLogService;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.Constant;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * <p>Title: 评价管理</p>
 * <p>Description: </p>
 * <p>Date: 2018/5/10</p>
 *
 * @author XN
 * @version 1.0
 */
@Service("updateRecommend")
public class UpdateRecommendImpl implements IUpdateRecommend {

    @Autowired
    private IEvaluateUserCustomerLog evaluateUserCustomerLog;
    @Autowired
    private IEvaluateUserCustomerLogService customerLogService;


    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<CustomerResponse> response = new House365RestResponse<CustomerResponse>();

        // 业务校验统一入口
        try {
            checkInterfaceParameter(map, Constant.IdParams);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }

        String id = getMapValueByKey("id", map, "");
        String oper = getMapValueByKey("oper", map, "");

        if (!Strings.isNullOrEmpty(id)) {
            //1审核通过 2删除
            if ("1".equalsIgnoreCase(oper)) {
                EvaluateUserCustomerLogEntity entity = (EvaluateUserCustomerLogEntity) customerLogService.getById(Integer.valueOf(id));
                if (entity != null && 1 != entity.getCheckStatus()) {
                    entity.setCheckStatus(1);
                    customerLogService.update(entity);
                }

            } else if ("2".equalsIgnoreCase(oper)) {
                evaluateUserCustomerLog.deleteEvaluateUserCustomerLogById(Integer.valueOf(id));
            }

        }

        response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
        response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());

        String result = JSONObject.fromObject(response).toString();
        return result;
    }

    /**
     * 业务层统校验自己所需参数是否存在
     * 所有参数都要存在
     *
     * @author hqc
     */
    protected void checkInterfaceParameter(Map<String, Object> map, String[] checkParams) throws IllegalServiceParameterException {
        // 方法所需参数
        for (String str : checkParams) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
