package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.EvaluateUserCustomerLogEntity;
import com.house365.beans.system.Page;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.web.util.DateTimeUtils;
import com.house365.ws.beans.request.EvaluateUserCustomerLogListRequest;
import com.house365.ws.beans.response.EvaluateUserCustomerLogListResponse;
import com.house365.ws.interfaces.server.IEvaluateUserCustomerLog;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>Title: 更新直销人员信息</p>
 * <p>Description: </p>
 * <p>Date: 2018/5/10</p>
 *
 * @author XN
 * @version 1.0
 */
@Service("getRecommendList")
public class GetRecommendListImpl implements IGetRecommendList {

    @Autowired
    private IEvaluateUserCustomerLog evaluateUserCustomerLog;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        Map<String, Object> paramsMap = parameter.getArgs();
        House365RestResponse<EvaluateUserCustomerLogListResponse> response = new House365RestResponse<>();

        String evaluateTimeStart = getMapValueByKey("evaluateTimeStart", paramsMap, "");
        String userId = getMapValueByKey("userId", paramsMap, "");
        String city = getMapValueByKey("city", paramsMap, "");
        String evaluateTimeEnd = getMapValueByKey("evaluateTimeEnd", paramsMap, "");
        String userName = getMapValueByKey("userName", paramsMap, "");
        String projectName = getMapValueByKey("projectName", paramsMap, "");
        String checkStatus = getMapValueByKey("checkStatus", paramsMap, "");

        String number = getMapValueByKey("page", paramsMap, "");
        String pagesize = getMapValueByKey("pagesize", paramsMap, "");

        Map<String, Object> searchParams = new HashMap<>();
        if (searchParams.containsKey("page")) {
            searchParams.remove("page");
        }
        if (searchParams.containsKey("pagesize")) {
            searchParams.remove("pagesize");
        }

        searchParams.remove("serviceName");
        searchParams.remove("serviceCode");

        // 获取查询条件
        if (!Strings.isNullOrEmpty(evaluateTimeStart)) {
            searchParams.put("GTE_evaluateTimeStart", evaluateTimeStart + " 00:00:00");
        }
        if (!Strings.isNullOrEmpty(evaluateTimeEnd)) {
            searchParams.put("LTE_evaluateTimeEnd", evaluateTimeEnd + " 23:59:59");
        }
        if (!Strings.isNullOrEmpty(userId)) {
            searchParams.put("EQ_userId", userId);
        }
        if (!Strings.isNullOrEmpty(city)) {
            searchParams.put("EQ_city", city);
        }
        if (!Strings.isNullOrEmpty(userName)) {
            searchParams.put("LIKE_userName", userName);
        }
        if (!Strings.isNullOrEmpty(projectName)) {
            searchParams.put("LIKE_projectName", projectName);
        }
        if (!Strings.isNullOrEmpty(checkStatus)) {
            searchParams.put("EQ_checkStatus", checkStatus);
        }

        searchParams.put("EQ_isEvaluated", 1);
        searchParams.put("EQ_isDeleted", 0);

        Page page = new Page(Integer.valueOf(pagesize));
        if (null != number) {
            page.setCurrentPage(Integer.parseInt(number));
        }

        House365RestObject<EvaluateUserCustomerLogListResponse> data = new House365RestObject<>();

        EvaluateUserCustomerLogListRequest listRequest = new EvaluateUserCustomerLogListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        EvaluateUserCustomerLogListResponse list = evaluateUserCustomerLog.getEvaluateUserCustomerLogList(listRequest);
        for (EvaluateUserCustomerLogEntity entity : list.getObjectList()) {
            if (null != entity.getCreateTime() && !"".equals(entity.getCreateTime())) {
                entity.setCreateDateStr(DateTimeUtils.parseDate(entity.getCreateTime(), DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_SHORT));
            }
            if (null != entity.getEvaluateTime() && !"".equals(entity.getEvaluateTime())) {
                entity.setEvaluateDateStr(DateTimeUtils.parseDate(entity.getEvaluateTime(), "yyyy-MM-dd HH:mm"));
            }
        }

        data.setEntity(list);

        response.setData(data);
        response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
        response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());

        String result = JSONObject.fromObject(response).toString();
        return result;
    }

    /**
     * 业务层统校验自己所需参数是否存在
     * 所有参数都要存在
     *
     * @author hqc
     */
    protected void checkInterfaceParameter(
        Map<String, Object> map, String[] checkParams
    ) throws IllegalServiceParameterException {
        // 方法所需参数
        for (String str : checkParams) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";

        if (map.containsKey(key) && map.get(key) != null) {
            if (map.get(key).getClass().getName().equalsIgnoreCase("java.lang.String")) {
                value = String.valueOf(map.get(key));
            } else {
                value = ((String[]) map.get(key))[0];
            }
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
