/**
 * Description: ReportChannelWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 上午 10:14:16
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.ReportChannelDepartRelEntity;
import com.house365.beans.entity.ReportChannelEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.ReportChannelListRequest;
import com.house365.ws.beans.request.ReportChannelRequest;
import com.house365.ws.beans.response.ReportChannelListResponse;
import com.house365.ws.beans.response.ReportChannelResponse;
import com.house365.ws.interfaces.server.IReportChannel;
import com.house365.ws.service.interfaces.IReportChannelDepartRelService;
import com.house365.ws.service.interfaces.IReportChannelService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * ReportChannelWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
@Service("reportChannel")
public class ReportChannelImpl implements IReportChannel {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportChannelImpl.class);

    /**
     * ReportChannel服务对象
     */
    @Autowired
    IReportChannelService<ReportChannelEntity> reportChannelService;

    @Autowired
    IReportChannelDepartRelService<ReportChannelDepartRelEntity> reportChannelDepartRelService;

    /**
     * ReportChannel列表查询
     *
     * @param request ReportChannel列表查询请求
     * @return ReportChannel列表查询响应
     */
    @Override
    public ReportChannelListResponse getReportChannelList(ReportChannelListRequest request) {
        ReportChannelListResponse response = new ReportChannelListResponse();
        try {
            QueryParams<ReportChannelEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<ReportChannelEntity> reportChannels = reportChannelService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(reportChannels);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存ReportChannel
     *
     * @param request ReportChannel请求
     * @return 保存ReportChannel响应
     */
    @Override
    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    public ReportChannelResponse addReportChannel(ReportChannelRequest request) {
        ReportChannelResponse response = new ReportChannelResponse();
        try {
            ReportChannelEntity entity = request.getEntity();
            reportChannelService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    @Override
    public ReportChannelResponse addReportChannels(ReportChannelRequest request, String[] departs) {
        ReportChannelResponse response = new ReportChannelResponse();
        try {
            ReportChannelEntity entity = request.getEntity();
            reportChannelService.save(entity);

            reportChannelDepartRelService.deleteByChannelId(entity.getId());

            if (departs != null && departs.length > 0) {
                for (String dep : departs) {
                    ReportChannelDepartRelEntity reportChannelDepartRelEntity = new ReportChannelDepartRelEntity();
                    reportChannelDepartRelEntity.setChannelId(entity.getId());
                    reportChannelDepartRelEntity.setDepartId(Integer.valueOf(dep));
                    reportChannelDepartRelService.save(reportChannelDepartRelEntity);
                }
            }

            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除ReportChannel通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除ReportChannel响应
     */
    @Override
    public ReportChannelResponse deleteReportChannelById(Integer id) {
        ReportChannelResponse response = new ReportChannelResponse();
        try {
            ReportChannelEntity entity = reportChannelService.getById(id);
            entity.setStatus(3);
            entity.setUpateTime(new Date());
            reportChannelService.update(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改ReportChannel
     *
     * @param request 修改ReportChannel请求
     * @return 修改ReportChannel响应
     */
    @Override
    public ReportChannelResponse updateReportChannel(ReportChannelRequest request) {
        ReportChannelResponse response = new ReportChannelResponse();
        try {
            reportChannelService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    @Override
    public ReportChannelResponse updateReportChannels(ReportChannelRequest request, String[] departs) throws Exception {
        ReportChannelResponse response = new ReportChannelResponse();
        try {
            reportChannelDepartRelService.deleteByChannelId(request.getEntity().getId());

            if (null != departs && departs.length > 0 && request.getEntity().getChannelType() == 1) {
                for (String dep : departs) {
                    ReportChannelDepartRelEntity reportChannelDepartRelEntity = new ReportChannelDepartRelEntity();
                    reportChannelDepartRelEntity.setChannelId(request.getEntity().getId());
                    reportChannelDepartRelEntity.setDepartId(Integer.valueOf(dep));
                    reportChannelDepartRelService.save(reportChannelDepartRelEntity);
                }
            }

            reportChannelService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
            throw ex;
        }
        return response;
    }

    /**
     * 通过ID获取ReportChannel
     *
     * @param id 唯一标识
     * @return 通过ID获取ReportChannel响应
     */
    @Override
    public ReportChannelResponse getReportChannelById(Integer id) {
        ReportChannelResponse response = new ReportChannelResponse();
        try {
            ReportChannelEntity entity = reportChannelService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
