/**
 * Description: ProjectUserWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 10:05:26
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.ProjectUserEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.ProjectUserListRequest;
import com.house365.ws.beans.request.ProjectUserRequest;
import com.house365.ws.beans.response.ProjectUserListResponse;
import com.house365.ws.beans.response.ProjectUserResponse;
import com.house365.ws.interfaces.server.IProjectUser;
import com.house365.ws.service.interfaces.IProjectUserService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

//import org.house365.core.support.QueryParams;

/**
 * ProjectUserWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
@Service("projectUser")
public class ProjectUserImpl implements IProjectUser {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectUserImpl.class);

    /**
     * ProjectUser服务对象
     */
    @Autowired
    IProjectUserService<ProjectUserEntity> projectUserService;


    @Override
    public List<UserEntity> queryUserByPrjId(Integer projectId) {
        return projectUserService.queryUserByPrjId(projectId);
    }

    /**
     * ProjectUser列表查询
     *
     * @param request
     *            ProjectUser列表查询请求
     * @return ProjectUser列表查询响应
     */
    @Override
    public ProjectUserListResponse getProjectUserList(ProjectUserListRequest request) {
        ProjectUserListResponse response = new ProjectUserListResponse();
        try {
            QueryParams<ProjectUserEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<ProjectUserEntity> projectUsers = projectUserService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(projectUsers);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存ProjectUser
     *
     * @param request
     *            ProjectUser请求
     * @return 保存ProjectUser响应
     */
    @Override
    public ProjectUserResponse addProjectUser(ProjectUserRequest request) {
        ProjectUserResponse response = new ProjectUserResponse();
        try {
            ProjectUserEntity entity = request.getEntity();
            projectUserService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除ProjectUser通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除ProjectUser响应
     */
    @Override
    public ProjectUserResponse deleteProjectUserById(Integer id) {
        ProjectUserResponse response = new ProjectUserResponse();
        try {
            projectUserService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改ProjectUser
     *
     * @param request
     *            修改ProjectUser请求
     * @return 修改ProjectUser响应
     */
    @Override
    public ProjectUserResponse updateProjectUser(ProjectUserRequest request) {
        ProjectUserResponse response = new ProjectUserResponse();
        try {
            projectUserService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取ProjectUser
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取ProjectUser响应
     */
    @Override
    public ProjectUserResponse getProjectUserById(Integer id) {
        ProjectUserResponse response = new ProjectUserResponse();
        try {
            ProjectUserEntity entity = projectUserService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
