/**
 * Description: StatusSourceStatistics数据访问接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-11-02 下午 17:54:57
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-11-02   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.StatusSourceStatisticsEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;

import com.house365.beans.entity.StatusSourceStatisticsEntity;

import java.util.List;
import java.util.Map;

/**
 * StatusSourceStatistics数据访问接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-11-02
 * @see
 * @since 1.0
 */
public interface IStatusSourceStatisticsDao<T extends StatusSourceStatisticsEntity> extends Dao<T> {
    List<Map> statisticCustomer(QueryParams<?> params);

    int countStatisticCustomer(QueryParams<?> params);

    List<Map> statisticCustomerByWeek(
        QueryParams<T> params
    );

    int countStatisticCustomerByWeek(QueryParams<?> params);

    List<Map> statisticCustomerByMonth(
        QueryParams<T> params
    );

    int countStatisticCustomerByMonth(QueryParams<?> params);

    List<Map> statisticStatusSource(QueryParams params);

    int countStatusSource(QueryParams<?> params);

    List<Map> statisticStatusSourceByWeek(
        QueryParams<T> params
    );

    int countStatusSourceByWeek(QueryParams<?> params);

    List<Map> statisticStatusSourceByMonth(
        QueryParams<T> params
    );

    int countStatusSourceByMonth(QueryParams<?> params);

    void updateProjectName();

    void updateSourceName();

    void updateCityName();

    void deleteByDate(String startDateStr);
}
