/**
 * Description: CustomerCallbackLogWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.CustomerCallbackLogEntity;
import com.house365.beans.entity.CustomerEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CustomerCallbackLogListRequest;
import com.house365.ws.beans.request.CustomerCallbackLogRequest;
import com.house365.ws.beans.response.CustomerCallbackLogListResponse;
import com.house365.ws.beans.response.CustomerCallbackLogResponse;

import java.util.List;
import java.util.Map;


/**
 * CustomerCallbackLogWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public interface ICustomerCallbackLog extends IService {

    /**
     * CustomerCallbackLog列表查询
     *
     * @param request CustomerCallbackLog列表查询请求
     * @return CustomerCallbackLog列表查询响应
     */
    CustomerCallbackLogListResponse getCustomerCallbackLogList(CustomerCallbackLogListRequest request);

    List<CustomerCallbackLogEntity> getCustomerCallbackLogList(Map<String, Object> map);

    /**
     * 保存CustomerCallbackLog
     *
     * @param request CustomerCallbackLog请求
     * @return 保存CustomerCallbackLog响应
     */
    CustomerCallbackLogResponse addCustomerCallbackLog(CustomerCallbackLogRequest request);

    /**
     * 删除CustomerCallbackLog通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除CustomerCallbackLog响应
     */
    CustomerCallbackLogResponse deleteCustomerCallbackLogById(Integer id);

    /**
     * 修改CustomerCallbackLog
     *
     * @param request 修改CustomerCallbackLog请求
     * @return 修改CustomerCallbackLog响应
     */
    CustomerCallbackLogResponse updateCustomerCallbackLog(CustomerCallbackLogRequest request);

    /**
     * 通过ID获取CustomerCallbackLog
     *
     * @param id 唯一标识
     * @return 通过ID获取CustomerCallbackLog响应
     */
    CustomerCallbackLogResponse getCustomerCallbackLogById(Integer id);

    /**
     * 拨打回访电话
     *
     * @param memPhone
     * @param customerId
     * @param userId     唯一标识
     * @return 通过ID获取CustomerCallbackLog响应
     */
    Integer calling(String memPhone, Integer customerId, Integer userId);

    /**
     * 拨打回访电话
     *
     * @param callbackLogId
     * @param userId        唯一标识
     * @return 通过ID获取CustomerCallbackLog响应
     */
    void handUp(Integer callbackLogId, String callContent, String buyIntention, Integer userId, String labelIds, String abandon);


    void saveCallBackLog(CustomerCallbackLogEntity customercallbacklogentity);

    List<CustomerCallbackLogEntity> queryByConditions(Map<String, Object> map);


}
