<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>销售转化报表分析</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>统计与分析
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>销售转化报表分析
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <form id="filterForm" name="filterForm" class="form-inline filterForm"
              action="${ctx}/statistic/salesConversionReport" method="get">

            <div style="margin-top:10px;">
                &nbsp;&nbsp;部门：&nbsp;&nbsp;
                <select name="department" id="department" class="span10 nochosen  multiselect" multiple="multiple"
                        data-placeholder="部门">
                    <option value='all'
                            <c:if test="${param['department'] eq 'all' or param['department'] eq null}">selected="selected"</c:if>>
                        全部
                    </option>
                    <c:forEach items="${departmentList}" var="d">
                        <option value="${d.id}"
                                <c:if test="${'1' eq d.type}">selected="selected"</c:if>>${d.name}</option>
                    </c:forEach>
                </select>
                &nbsp;&nbsp;&nbsp;&nbsp;职员：&nbsp;&nbsp;
                <span id="userDiv">
                        <select name="user" id="user" class="span10 nochosen  multiselect" multiple="multiple"
                                data-placeholder="职员">
                            <option value='all'
                                    <c:if test="${param['user'] eq 'all'}">selected="selected"</c:if>>全部</option>
                        </select>
                    </span>
                &nbsp;&nbsp;
            </div>

            <div style="margin-top:10px;">
                &nbsp;&nbsp;数据日期：&nbsp;&nbsp;
                <input type="text" name="startTime" id="startTime" class="m-wrap small mydate span2" placeholder="起始时间">到
                <%--<input type="text" name="startTime" id="startTime" class="m-wrap small my-o-date span2" placeholder="起始时间">到--%>
                <input type="text" name="endTime" id="endTime" class="m-wrap small mydate span2" placeholder="截止时间">
                &nbsp;&nbsp;
                <a class="btn " onclick="btnSubmit();">提交</a>
                &nbsp;&nbsp;
                <a class="btn" onclick="exportExcel();">Excel下载</a>

            </div>

            <input type="hidden" id="departmentIds" name="departmentIds" value="${departmentIds}"/>
            <input type="hidden" id="departmentNames" name="departmentNames" value="${departmentNames}"/>
            <input type="hidden" id="userIds" name="userIds" value="${userIds}"/>
            <input type="hidden" id="userNames" name="userNames" value="${userNames}"/>
            <input type="hidden" id="displayTab" name="displayTab" value="${displayTab}"/>

        </form>

        <table class="table table-bordered table-advance table-hover">
            <tr class="info">
                <td width="100" style="text-align:center">部门</td>
                <td width="100" style="text-align:center">安家顾问</td>
                <td width="100" style="text-align:center">私客总量</td>
                <td width="100" style="text-align:center">已跟进量</td>
                <td width="100" style="text-align:center">AB类</td>

                <td width="100" style="text-align:center">约看</td>
                <td width="100" style="text-align:center">到访</td>
                <td width="100" style="text-align:center">到访转化率</td>
                <td width="100" style="text-align:center">认筹</td>
                <td width="100" style="text-align:center">认筹转化率</td>

                <td width="100" style="text-align:center">认购</td>
                <td width="100" style="text-align:center">认购转化率</td>
                <td width="100" style="text-align:center">签约</td>
                <td width="100" style="text-align:center">签约转化率</td>
                <td width="100" style="text-align:center">退房</td>
            </tr>

            <c:if test="${ empty departmentList}">
                <tr>
                    <td colspan="10" style="text-align: center">暂无城市部门配置，请添加</td>
                </tr>
            </c:if>
            <c:if test="${not empty departmentList}">
                <c:if test="${not empty tableData}">
                    <c:forEach items="${tableData}" var="item">
                        <tr>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.deptName}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.managerName}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.count}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.callBackCount}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.abCount}
                            </td>

                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.seeCount}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.daoCount}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.daoRate}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.renCount}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.renRate}
                            </td>

                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.buyCount}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.buyRate}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.signCount}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.signRate}
                            </td>
                            <td nowrap="nowrap" style="text-align:center;">
                                    ${item.cancelCount}
                            </td>
                        </tr>
                    </c:forEach>
                </c:if>
                <c:if test="${ empty tableData}">
                    <tr>
                        <td colspan="15" style="text-align: center">暂未找到与条件相关的数据，请重新搜索</td>
                    </tr>
                </c:if>
            </c:if>

        </table>
    </div>

</div>

<input type="hidden" value="${queryUser}" name="queryUser" id="queryUser">

<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script src="${ctx}/resources/script/echarts/echarts.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>

<script type="text/javascript">

    $(document).ready(function () {
        var timeStart = "${startTime}";
        var timeEnd = "${endTime}";
        if (timeEnd == '' && timeStart == '') {
            $(".mydate").unbind("focus");
            $(".mydate").bind("focus", function () {
                WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-{%d}'});
            });
            setTime();
        } else {
            $("#startTime").val(timeStart);
            $("#endTime").val(timeEnd);
        }
    });

    $(document).ready(function () {
        if ($('#department')) {
            $('#department').multiselect({
                includeSelectAllOption: true,
                enableFiltering: true,
                maxHeight: 500,
                buttonWidth: 320,
                numberDisplayed: 2,
                filterPlaceholder: '请输入部门名',
                includeSelectAllOption: false,
                templates: {
                    filterClearBtn: '<span></span>',
                },
                buttonText: function (options) {
                    if (options.length == 0) {
                        return '未选择部门 ';
                    } else if (options.length > 5) {
                        return '已选' + options.length + '个 ';
                    } else {
                        var selected = '';
                        options.each(function () {
                            selected += $(this).text() + ', ';
                        });
                        return selected.substr(0, selected.length - 2);
                    }

                },
                optionLabel: function (element) {
                    return $(element).html();
                },
                onInitialized: function (select, container) {
                    var selectedOptions = $('#department option:selected');
                    var userSelectedOptions = $('#user option:selected').val();
                    var contain = $('#userDiv');
                    contain.empty();
                    if (userSelectedOptions == 'all') {
                        contain.append("<select name=\"user\" id=\"user\" class=\"span10 nochosen  multiselect\" multiple=\"multiple\" data-placeholder=\"职员\"><option value='all' selected>全部</option></select>");
                    } else {
                        contain.append("<select name=\"user\" id=\"user\" class=\"span10 nochosen  multiselect\" multiple=\"multiple\" data-placeholder=\"职员\"><option value='all'>全部</option></select>");
                    }

                    var deptId = "";
                    if (selectedOptions.val() == 'all') {
                        $('#department option').each(function () {
                            if ('all' != $(this).val()) {
                                deptId += $(this).val() + ",";
                            }
                        });
                    } else {
                        var dropdown = $('#department').siblings('.open');
                        $('#department option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                        selectedOptions.each(function () {
                            deptId += $(this).val() + ",";
                        });
                    }

                    if (selectedOptions.val()) {
                        $.ajax({
                            url: "${ctx}/user/getUserAjax",
                            type: "GET",
                            data: {dept: deptId, queryUser: $("#queryUser").val()},
                            dataType: "json",
                            success: function (data) {
                                var user = $('#user');
                                $(data).each(function () {
                                    if ('1' == this.weiXinId) {
                                        user.append("<option selected value='" + this.id + "'>" + this.realName + "</option>");
                                    } else {
                                        user.append("<option value='" + this.id + "'>" + this.realName + "</option>");
                                    }
                                });
                            },
                            complete: function () {
                                initUser();
                            }
                        });
                    } else {
                        initUser();
                    }

                },
                onChange: function (option, checked) {
                    var flag;
                    if (option.val() == 'all') {
                        flag = false;
                    } else {
                        if (checked == true) {
                            flag = true;
                        }
                    }
                    var selectedOptions = $('#department option:selected');
                    var selectedLast = $('#department option:selected:last');
                    if (selectedOptions.val() == 'all' && selectedLast.val() != 'all' && flag == true) {
                        $('#department').multiselect('deselect', ['all']);
                    }
                    selectedOptions = $('#department option:selected');
                    var contain = $('#userDiv');
                    contain.empty();
                    contain.append("<select name=\"user\" id=\"user\" class=\"span10 nochosen  multiselect\" multiple=\"multiple\" data-placeholder=\"职员\">\n" +
                        "<option value='all'>全部</option></select>");

                    var deptId = "";

                    if (selectedOptions.val() == 'all') {
                        $('#department option').each(function () {
                            if ('all' != $(this).val()) {
                                deptId += $(this).val() + ",";
                                $(this).removeAttr("selected");
                                $('#department').multiselect('refresh');
                            }
                        });
                    } else {
                        selectedOptions.each(function () {
                            deptId += $(this).val() + ",";
                        });
                    }

                    if (selectedOptions.val()) {
                        $.ajax({
                            url: "${ctx}/user/getUserAjax",
                            type: "GET",
                            data: {dept: deptId},
                            dataType: "json",
                            success: function (data) {
                                var user = $('#user');
                                $(data).each(function () {
                                    user.append("<option value='" + this.id + "'>" + this.realName + "</option>");
                                });
                            },
                            complete: function () {
                                initUser();
                            }
                        });
                    } else {
                        initUser();
                    }

                }
            });
        }

        var startTime = $("#startTime");
        var endTime = $("#endTime");
        endTime.bind("focus", function () {
            WdatePicker({startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d}'});
        });
        startTime.bind("focus", function () {
            WdatePicker({
                skin:'default',minDate:'2018-07-01 00:00:00',
                startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d}',
                onpicked: function () {
                    WdatePicker({
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        maxDate: '%y-%M-{%d}',
                        el: 'endTime'
                    })
                }
            });
        });

        dispayFun("${displayTab}");
    });

    function initUser() {
        if ($('#user')) {
            $('#user').multiselect({
                includeSelectAllOption: true,
                enableFiltering: true,
                maxHeight: 500,
                buttonWidth: 320,
                numberDisplayed: 2,
                filterPlaceholder: '请输入职员名',
                includeSelectAllOption: false,
                templates: {
                    filterClearBtn: '<span></span>',
                },
                buttonText: function (options) {
                    if (options.length == 0) {
                        return '未选择职员 ';
                    } else if (options.length > 5) {
                        return '已选' + options.length + '个 ';
                    } else {
                        var selected = '';
                        options.each(function () {
                            selected += $(this).text() + ', ';
                        });
                        return selected.substr(0, selected.length - 2);
                    }
                },
                optionLabel: function (element) {
                    return $(element).html();
                },
                onInitialized: function (select, container) {
                    var selectedOptions = $('#user option:selected');

                    if (selectedOptions.val() == 'all') {

                    } else {
                        var dropdown = $('#user').siblings('.open');
                        $('#user option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                    }
                },
                onChange: function (option, checked) {
                    var flag;
                    if (option.val() == 'all') {
                        flag = false;
                    } else {
                        if (checked == true) {
                            flag = true;
                        }
                    }
                    var selectedOptions = $('#user option:selected');
                    var selectedLast = $('#user option:selected:last');
                    if (selectedOptions.val() == 'all' && selectedLast.val() != 'all' && flag == true) {
                        $('#user').multiselect('deselect', ['all']);
                    }
                    selectedOptions = $('#user option:selected');

                    if (selectedOptions.val() == 'all') {
                        $('#user option').each(function () {
                            if ('all' != $(this).val()) {
                                $(this).removeAttr("selected");
                                $('#user').multiselect('refresh');
                            }
                        });
                    } else {
                        var dropdown = $('#user').siblings('.open');
                        $('#user option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                    }
                }
            });

        }

    }

    function btnSubmit() {
        $('#filterForm').submit();
    }

    function dispayFun(obj) {
        if (obj == 1) {
            $("#report").show();
            $("#table").hide();
            $("#reportLi").addClass("active");
            $("#tableLi").removeClass("active");
            $("#displayTab").val("1");
        } else {
            $("#table").show();
            $("#report").hide();
            $("#tableLi").addClass("active");
            $("#reportLi").removeClass("active");
            $("#displayTab").val("2");
        }
    }

    function setTime() {
        var startTime = $("#startTime");
        var endTime = $("#endTime");
        if (startTime.val() == '') {
            startTime.val(getYesterday());
        }
        if (endTime.val() == '') {
            endTime.val(getYesterday());
        }
    }

    function exportExcel() {
        document.filterForm.action = "${ctx}/statistic/salesConversionReportExcel";
        $('#filterForm').submit();
        document.filterForm.action = "${ctx}/statistic/salesConversionReport";
    }

</script>
</body>
</html>
