<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>云迹数据报表</title>
</head>
<body>
<style>
    body {
        padding: 20px;
    }

    .demo-input {
        padding-left: 10px;
        height: 38px;
        min-width: 262px;
        line-height: 38px;
        border: 1px solid #e6e6e6;
        background-color: #fff;
        border-radius: 2px;
    }

    .demo-footer {
        padding: 50px 0;
        color: #999;
        font-size: 14px;
    }

    .demo-footer a {
        padding: 0 5px;
        color: #01AAED;
    }
    input[disabled], select[disabled], textarea[disabled], input[readonly], select[readonly], textarea[readonly] {
        cursor: auto !important;
        background: none !important;
    }
</style>
<%--<script src="${static_common}/jquery-1.11.1.min.js"></script> <!-- 改成你的路径 -->--%>
<script type="text/javascript" src="${ctx}/resources/script/laydate/laydate.js"></script>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>统计与分析
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>云迹数据报表
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <form id="filterForm" name="filterForm" class="form-inline filterForm"
              action="${ctx}/statistic/cloudCusReport" method="get">

            <div style="margin-top:10px;">
                <select id="selectedOption" class="demo-input dateSelector" name="search_degree" lay-filter="required"
                        date-target="WORLD" value="${param['search_degree']}">
                    <%--<option value="y">年</option>--%>
                    <%--<option value="bn">半年</option>--%>
                    <%--<option value="s">季</option>--%>
                    <%--<option value="m">月</option>--%>
                    <option value="m"
                            <c:if test="${'m' eq param['search_degree']}">selected="selected"</c:if>>
                        月
                    </option>
                    <option value="y"
                            <c:if test="${'y' eq param['search_degree']}">selected="selected"</c:if>>
                        年
                    </option>
                    <option value="bn"
                            <c:if test="${'bn' eq param['search_degree']}">selected="selected"</c:if>>
                        半年
                    </option>
                    <option value="s"
                            <c:if test="${'s' eq param['search_degree']}">selected="selected"</c:if>>
                        季
                    </option>
                </select>

                <input id="worldId" type="text" name="search_worldId" value="${param['search_worldId']}" readonly
                       class="demo-input dateTargetWORLD"
                       placeholder="请输入时间范围"/>
                <input id="search_time" type="hidden" name="search_time"/>
                <%--<br/><br/><br/>--%>
                <%--<br/>--%>
                <%--&nbsp;&nbsp;日期类型：&nbsp;&nbsp;--%>
                <%--<input type="text" name="search_startTime" id="search_startTime"--%>
                <%--value="${param['search_startTime']}"--%>
                <%--class="m-wrap small mydate span2 " placeholder="月份">--%>
                &nbsp;&nbsp;
                创建人：<input type="text" id="search_name" style="border: 1px solid #d5d5d5;"
                           name="search_name"
                           value="${param['search_name']}"
                           class="m-wrap small" placeholder="创建人">&nbsp;&nbsp;&nbsp;&nbsp;
                <a class="btn" onclick="btnSubmit();">搜索</a>
            </div>
        </form>

        <table class="table table-bordered table-advance table-hover">
            <tr class="info">
                <td width="100" style="text-align:center">创建人</td>
                <td width="100" style="text-align:center">总数</td>
                <td width="100" style="text-align:center">待派</td>
                <td width="100" style="text-align:center">已派</td>
                <td width="100" style="text-align:center">派工率</td>

                <td width="100" style="text-align:center">已跟进</td>
                <td width="100" style="text-align:center">跟进率</td>
                <td width="100" style="text-align:center"> A/B意向数</td>
                <td width="100" style="text-align:center">有效率</td>
                <td width="100" style="text-align:center">约看数</td>
                <td width="100" style="text-align:center">约看转化率</td>
                <td width="100" style="text-align:center">到访数</td>
                <td width="100" style="text-align:center">到访转化率</td>
                <td width="100" style="text-align:center">认购数</td>
                <td width="100" style="text-align:center">签约数</td>
                <td width="100" style="text-align:center">成交数</td>
                <td width="100" style="text-align:center">成交转化率</td>
            </tr>
            <c:if test="${not empty dataList}">
                <c:forEach items="${dataList}" var="item" varStatus="i">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.name}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.count}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.waitCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.sendCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.paiRate}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.backCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.backRate}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.abCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.abRate}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.seeCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.seeRate}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                            <a onclick="getDetail(${item.createId}, 2,${item.daoCount},${item.id})">${item.daoCount}</a>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.daoRate}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <a onclick="getDetail( ${item.createId},4,${item.buyCount},${item.id})">${item.buyCount}</a>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <a onclick="getDetail( ${item.createId},5,${item.signCount},${item.id})">${item.signCount}</a>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.successCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.successRate}
                        </td>
                    </tr>
                </c:forEach>
            </c:if>
            <c:if test="${ empty dataList}">
                <tr>
                    <td colspan="15" style="text-align: center">暂未找到与条件相关的数据，请重新搜索</td>
                </tr>
            </c:if>
        </table>
    </div>

</div>


<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script language="javascript" type="text/javascript" src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>

<script type="text/javascript">

    function btnSubmit() {
        getDateText();
        $('#filterForm').submit();
    }

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            getDateText();
            $('#filterForm').submit();
        }
    });

    function getDetail(createId, status, count, id) {
        if (count > 0) {
            window.open("/house365-hgs-web/cloudactivity/cloudCusList/" + createId + "/" + status + "/" + id, "_blank");
        }
    }

    //    $(document).ready(function () {
    //        var startTime = $("#search_startTime");
    //        startTime.bind("focus", function () {
    //            WdatePicker({
    //                startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d}',
    //                onpicked: function () {
    //                    WdatePicker({
    //                        dateFmt: "yyyy-MM-dd",
    //                        autoPickDate: true,
    //                        maxDate: '%y-%M-{%d}',
    //                        el: 'endTime'
    //                    })
    //                }
    //            });
    //        });
    //        $(".mydate").unbind("focus");
    //        $(".mydate").bind("focus", function () {
    //            WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-{%d}'});
    //        });
    //    });

    //插件开始
    lay('#version').html('-v' + laydate.v);
    $Date = laydate;

    //联动测试
    initDateForm();

    /**
     * 季度初始化
     * @param ohd 季度input dom对象非jquery对象
     * @param sgl 有值单个，无值默认范围
     */
    function renderSeasonDate(ohd, sgl) {
        var ele = $(ohd);
        $Date.render({
            elem: ohd,
            type: 'month',
            format: 'yyyy年M季度',
            range: sgl ? null : '~',
            min: "1900-1-1",
            max: "2099-12-31",
            btns: ['clear', 'confirm'],
            ready: function (value, date, endDate) {
                var hd = $("#layui-laydate" + ele.attr("lay-key"));
                if (hd.length > 0) {
                    hd.click(function () {
                        ren($(this));
                    });
                }
                ren(hd);
            },
            done: function (value, date, endDate) {
                console.log(value);
                console.log(date);
                console.log(endDate);
                if (!isNull(date) && date.month > 0 && date.month < 5) {
                    ele.attr("startDate", date.year + "-" + date.month);
                } else {
                    ele.attr("startDate", "");
                }
                if (!isNull(endDate) && endDate.month > 0 && endDate.month < 5) {
                    ele.attr("endDate", endDate.year + "-" + endDate.month)
                } else {
                    ele.attr("endDate", "");
                }
            }
        });
        var ren = function (thiz) {
            var mls = thiz.find(".laydate-month-list");
            mls.each(function (i, e) {
                $(this).find("li").each(function (inx, ele) {
                    var cx = ele.innerHTML;
                    if (inx < 4) {
                        ele.innerHTML = cx.replace(/月/g, "季度");
                    } else {
                        ele.style.display = "none";
                    }
                });
            });
        }
    }

    function renderSeason(ohd, sgl) {
        var ele = $(ohd);

        $Date.render({
            elem: ohd,
            type: 'month',
            format: 'yyyy年M半年',
            range: sgl ? null : '~',
            min: "1900-1-1",
            max: "2099-12-31",
            btns: ['clear', 'confirm'],
            ready: function (value, date, endDate) {
                var hd = $("#layui-laydate" + ele.attr("lay-key"));
                if (hd.length > 0) {
                    hd.click(function () {
                        ren($(this));
                    });
                }
                ren(hd);
            },
            done: function (value, date, endDate) {
                console.log(value);
                console.log(date);
                console.log(endDate);
                if (!isNull(date) && date.month > 0 && date.month < 3) {
                    ele.attr("startDate", date.year + "-" + date.month);
                } else {
                    ele.attr("startDate", "");
                }
                if (!isNull(endDate) && endDate.month > 0 && endDate.month < 3) {
                    ele.attr("endDate", endDate.year + "-" + endDate.month)
                } else {
                    ele.attr("endDate", "");
                }
            }
        });
        var ren = function (thiz) {
            var mls = thiz.find(".laydate-month-list");
            mls.each(function (i, e) {
                    $(this).find("li").each(function (inx, ele) {
                        var cx = ele.innerHTML;
                        if (inx == 0) {
                            var ss = inx + '月';
                            console.info(ss);
                            // ele.innerHTML = cx.replace(/一月/g, "上半年");
                            //ele.innerHTML = cx.replace(/(一月|二月|三月|四月|五月|六月)/g, "上半年");
                            ele.innerHTML = cx.replace(/一月/g, "上半年");
                            //$(".laydate-month-list").html(cx.replace(/(一月|二月|三月|四月|五月|六月)/g, "上半年"))
                        } else if (inx == 1) {
                            ele.innerHTML = cx.replace(/二月/g, "下半年");
                        }
                        else {
                            ele.style.display = "none";
                        }

                    });
                }
            );
        }
    }

    /**
     * 初始化表单中年季月日范围选择
     * 下拉框与日期框对应：
     *  <select class="dateSelector" date-target="PI" ...
     *  <input type="text" class="dateTargetPI" readonly ...
     *  PI为自定义的对应关键字
     *
     * @param form 要渲染的form的jquery对象，当form为空默认值为全页面
     * @param sgl 有值单个，无值默认范围
     */
    function initDateForm(sgl, form) {
        if (isNull(form)) form = $(document.body);
        var ltm = function (tar, tars, tva) {
            tars.each(function () {
                $(this).removeAttr("lay-key");
                this.outerHTML = this.outerHTML;
            });
            tars = form.find(".dateTarget" + tar);
            tars.each(function () {
                var ele = $(this);
                if ("y" == tva) {
                    $Date.render({
                        elem: this,
                        type: 'year'
                    });

                } else if ("bn" == tva) {
                    ele.attr("startDate", "");
                    ele.attr("endDate", "");
                    renderSeason(this, 1);
                } else if ("s" == tva) {
                    ele.attr("startDate", "");
                    ele.attr("endDate", "");
                    renderSeasonDate(this, 1);
                } else if ("m" == tva) {
                    ele.attr("startDate", "");
                    ele.attr("endDate", "");
                    $Date.render({
                        elem: this,
                        type: 'month'
                    });
                }
            });
        };
        var sels = form.find(".dateSelector");
        sels.each(function (i, e) {
            var ths = this;
            var thiz = $(e);
            var tar = thiz.attr("date-target");
            thiz.next().find("dd").click(function () {
                var tva = thiz.val();
                var tars = form.find(".dateTarget" + tar);
                ltm(tar, tars, tva);
            });
            thiz.change(function () {
                var tva = $(this).val();
                var tars = form.find(".dateTarget" + tar);
                ltm(tar, tars, tva);
            });
            var tars = form.find(".dateTarget" + tar);
            ltm(tar, tars, thiz.val());
        });
    }

    function isNull(s) {
        if (s == null || typeof (s) == "undefined" || s == "") return true;
        return false;
    }

    function getDateText() {
        var ele = $("#worldId");
        var sele = $("#selectedOption").val();
        var selectDate = ''
        if (sele == 'y') {
            selectDate = ele.val() + "-01-01 00:00:00" + ',' + ele.val() + "-12-31 23:59:59"
        } else if (sele == 'bn') {
            var selectBn = ele.val().substr(5, 1);
            var val = ele.val().substr(0, 4);
            if (selectBn == '1') {
                selectDate = val + "-01-01 00:00:00" + ',' + val + "-06-30 23:59:59"
            } else if (selectBn == '2') {
                selectDate = val + "-07-01 00:00:00" + ',' + val + "-12-31 23:59:59"
            }

        } else if (sele == 's') {
            var selectJd = ele.val().substr(5, 1);
            var val = ele.val().substr(0, 4);
            if (selectJd == '1') {
                selectDate = val + "-01-01 00:00:00" + ',' + val + "-03-31 23:59:59"
            } else if (selectJd == '2') {
                selectDate = val + "-04-01 00:00:00" + ',' + val + "-06-30 23:59:59"
            } else if (selectJd == '3') {
                selectDate = val + "-07-01 00:00:00" + ',' + val + "-09-30 23:59:59"
            } else if (selectJd == '4') {
                selectDate = val + "-10-01 00:00:00" + ',' + val + "-12-31 23:59:59"
            }

        } else if (sele == 'm') {
            var selectMonth = ele.val().substr(5, 2);
            if (selectMonth == '01' || selectMonth == '03' || selectMonth == '05' || selectMonth == '07' || selectMonth == '08' || selectMonth == '11' || selectMonth == '12') {
                selectDate = ele.val() + "-01 00:00:00" + ',' + ele.val() + "-31 23:59:59"
            } else {
                selectDate = ele.val() + "-01 00:00:00" + ',' + ele.val() + "-30 23:59:59"
            }

        }
        console.info(selectDate);
        $("#search_time").val(selectDate);
    }
</script>
</body>
</html>
