<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>抢客规则列表</title>
    <style>
        .tdText {
            word-wrap: break-word;
            word-break: break-all;
            white-space: pre-line;
        }
    </style>
</head>
<body>
<%-- <div class="row${fluid}">
    <div class="span6">
        <h2 class="page-title">抢客规则列表</h2>
    </div>
    <div class="span6 header_buttons">
        <a href="${ctx}/rushcustomerrule?action=create" class="btn blue pull-right"><i class="icon-plus"></i></a>
    </div>
</div> --%>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>抢客规则列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/rushcustomerrule" method="get">
                <input type="text" name="search_LIKE_departmentName" value="${param['search_LIKE_departmentName']}"
                       class="m-wrap small" placeholder="部门">
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/rushcustomerrule?action=create" class="btn blue pull-right" title="新增"><i
                            class="icon-plus"></i></a>
                </div>
                <div class="buttons pull-right">
                    <a href="javascript:void(0);" onclick="deleteById('')" class="btn blue pull-right" title="删除"><i
                            class="icon-minus"></i></a>
                </div>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="50">id</th>
            <th width="200">部门</th>
            <th width="200">项目规则</th>
            <th width="200">来源规则</th>
            <th width="100">添加时间</th>
            <th width="100">最后修改时间</th>
            <th width="50">修改人</th>
            <th width="100">操作</th>
        </tr>
        </thead>
        <c:forEach items="${rushCustomerRules}" var="rushCustomerRule">
            <tr>
                <td nowrap="nowrap">
                    <a href="${ctx}/rushcustomerrule/${rushCustomerRule.id}"> <c:if
                            test="${null ne rushCustomerRule.id && '' ne rushCustomerRule.id}">
                        <c:out value="${rushCustomerRule.id}"/>
                    </c:if>
                        <c:if test="${null eq rushCustomerRule.id || '' eq rushCustomerRule.id}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td nowrap="nowrap" class="tdText"><c:if
                        test="${null ne rushCustomerRule.department && '' ne
                         rushCustomerRule.department}">${fn:substring(rushCustomerRule.departmentName, 0, 35)}<c:if
                            test="${fn:length(rushCustomerRule.departmentName)>35}">...</c:if>
                </c:if><c:if test="${null eq rushCustomerRule.department || '' eq rushCustomerRule.department}">
                        &nbsp;
                </c:if></td>
                <td nowrap="nowrap" class="tdText"><c:if
                        test="${null ne rushCustomerRule.project && '' ne
                         rushCustomerRule.project}">${fn:substring(rushCustomerRule.projectName, 0, 35)}<c:if
                        test="${fn:length(rushCustomerRule.projectName)>35}">...</c:if>
                </c:if><c:if test="${null eq rushCustomerRule.project || '' eq rushCustomerRule.project}">
                    &nbsp;
                </c:if></td>
                <td nowrap="nowrap" class="tdText"><c:if
                        test="${null ne rushCustomerRule.source && '' ne
                         rushCustomerRule.source}">${fn:substring(rushCustomerRule.sourceName, 0, 35)}<c:if
                        test="${fn:length(rushCustomerRule.sourceName)>35}">...</c:if>
                </c:if><c:if test="${null eq rushCustomerRule.source || '' eq rushCustomerRule.source}">
                    &nbsp;
                </c:if></td>
                <td nowrap="nowrap">
                    <c:if test="${null ne rushCustomerRule.createTime && '' ne rushCustomerRule.createTime}">
                        <f:formatDate value='${rushCustomerRule.createTime}' pattern='yyyy-MM-dd HH/mm/ss'/>
                    </c:if>
                    <c:if test="${null eq rushCustomerRule.createTime || '' eq rushCustomerRule.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne rushCustomerRule.updateTime && '' ne rushCustomerRule.updateTime}">
                        <f:formatDate value='${rushCustomerRule.updateTime}' pattern='yyyy-MM-dd HH/mm/ss'/>
                    </c:if>
                    <c:if test="${null eq rushCustomerRule.updateTime || '' eq rushCustomerRule.updateTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne rushCustomerRule.updateUserName && '' ne rushCustomerRule.updateUserName}">
                        <c:out value="${rushCustomerRule.updateUserName}"/>
                    </c:if>
                    <c:if test="${null eq rushCustomerRule.updateUserName || '' eq rushCustomerRule.updateUserName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${empty rushCustomerRule.status || rushCustomerRule.status eq 0 }">
                        <a href="#2"
                           onclick="changeStatus('${rushCustomerRule.id}',1)">启用</a>
                    </c:if>
                    <c:if test="${rushCustomerRule.status eq 1}">
                        <a href="#2"
                           onclick="changeStatus('${rushCustomerRule.id}',0)">禁用</a>
                    </c:if>
                    &nbsp;&nbsp;<i class="icon-edit pointer icon-large"
                                   onclick="window.location='${ctx}/rushcustomerrule/${rushCustomerRule.id}?action=edit'"></i>
                    &nbsp;&nbsp; <i
                        title="删除"
                        class="icon-minus pointer icon-large"
                        onclick="deleteById('${rushCustomerRule.id}')"> </i>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    function changeStatus(id, status) {
        $.ajax({
            url: '${ctx}/rushcustomerrule/changeStatus/' + id + '/' + status,
            type: "POST",
            success: function (data) {
                if ("10000" == data) {
                    window.location.reload();
                }
                else {
                    House365Util.showAlertMessage(
                        $("#message"),
                        "抢客规则修改失败！",
                        "error");
                }
            }
        });
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除规则", "请至少选择一条规则!", function () {
            });
        }
        else {
            House365Util.createModal("删除规则", "确定要删除该规则？", function () {
                $.ajax({
                    url: '${ctx}/rushcustomerrule/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

</script>
</body>
</html>
