<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>

<form id="input_form" class="form-horizontal valid"
      action="${ctx}/rushcustomerrule<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/rushcustomerrule">抢客规则表列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="button" onclick="formSubmit();">
                                <i class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/rushcustomerrule/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue" type="button" onclick="formSubmit();"></i>&nbsp;保存</button>
                            <a href="${ctx}/rushcustomerrule" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/rushcustomerrule/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/rushcustomerrule" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <input name="entity.status" type="hidden" value="${entity.status}"/>
                    <input type="hidden" id="entity.createUserId"
                           name="entity.createUserId" value="${entity.createUserId}"/>
                    <input type="hidden" id="entity.createUserName"
                           name="entity.createUserName" value="${entity.createUserName}"/>
                    <input type="hidden" id="entity.createTimeStr"
                           name="entity.createTimeStr"
                           value="<fmt:formatDate value='${entity.createTime}' pattern='yyyy-MM-dd HH:mm:ss' />"/>
                    <input type="hidden" id="entity.updateUserId"
                           name="entity.updateUserId" value="${entity.updateUserId}"/>
                    <input type="hidden" id="entity.updateUserName"
                           name="entity.updateUserName" value="${entity.updateUserName}"/>
                    <input type="hidden" id="entity.updateTimeStr"
                           name="entity.updateTimeStr"
                           value="<fmt:formatDate value='${entity.updateTime}' pattern='yyyy-MM-dd HH:mm:ss' />"/>

                    <input type="hidden" id="buildingId" name="entity.project" class="required"
                           value="${entity.project}"/>
                    <input type="hidden" id="activeTimeName" name="entity.activeTimeName"
                           value="${entity.activeTimeName}"/>
                    <input type="hidden" id="sourceName" name="entity.sourceName" value="${entity.sourceName}"/>
                    <input type="hidden" id="departmentName" name="entity.departmentName"
                           value="${entity.departmentName}"/>
                    <input type="hidden" id="cityCode" name="entity.cityCode"
                           value="${entity.cityCode}"/>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">部门<font color="red">*</font>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <select name="entity.department" id="department"
                                                class="span10 nochosen  multiselect"
                                                multiple="multiple"
                                                data-placeholder="部门">
                                            <c:forEach items="${departments}" var="d">
                                                <option value="${d.id}"
                                                        <c:if test="${'1' eq d.type}">selected="selected"</c:if>>${d.name}</option>
                                            </c:forEach>
                                        </select>
                                        <font color="red"><form:errors
                                                path="rushCustomerRuleVo.entity.departmentName"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.departmentName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">生效时间<font color="red">*</font>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <select name="entity.activeTime" id="activeTime"
                                                class="span10 nochosen  multiselect"
                                                multiple="multiple"
                                                data-placeholder="生效时间">
                                            <c:forEach items="${dictionaries}" var="d">
                                                <option value="${d.dicValue}"
                                                        <c:if test="${'1' eq d.city}">selected="selected"</c:if>>${d.dicName}</option>
                                            </c:forEach>
                                        </select>
                                        <font color="red"><form:errors
                                                path="rushCustomerRuleVo.entity.activeTime"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.activeTimeName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">楼盘<font color="red">*</font>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="buildingName" name="entity.projectName"
                                               class="required span12"
                                               onclick="assignBuilding(10)"
                                               value="${entity.projectName}"/>
                                        <font color="red"><form:errors
                                                path="rushCustomerRuleVo.entity.project"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.projectName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">来源<font color="red">*</font>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <select name="entity.source" id="source" class="span10 nochosen  multiselect"
                                                multiple="multiple"
                                                data-placeholder="来源">
                                            <c:forEach items="${sources}" var="s">
                                                <option value="${s.sourceId}"
                                                        <c:if test="${s.flag}">selected="selected"</c:if> >${s.sourceName}</option>
                                            </c:forEach>
                                        </select>

                                        <font color="red"><form:errors path="rushCustomerRuleVo.entity.source"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.sourceName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</form>
<script>
    //    function chooseSource() {
    //        House365Util.createRemoteModal("选择来源", "/house365-hgs-web/basetree/modalTree?choseIds=" + $("#source").val(), null, function () {
    //            $("#source").val($("#choseIds").val());
    //            $("#sourceName").text($("#sourceSel").val());
    //        });
    //    }

    $(function () {
        if ($('#department')) {
            $('#department').multiselect({
                enableFiltering: true,
                maxHeight: 500,
                buttonWidth: 320,
                numberDisplayed: 2,
                filterPlaceholder: '请输入部门名',
                includeSelectAllOption: false,
                templates: {
                    filterClearBtn: '<span></span>',
                },
                buttonText: function (options) {
                    if (options.length == 0) {
                        return '未选择部门 ';
                    } else if (options.length > 5) {
                        return '已选' + options.length + '个 ';
                    } else {
                        var selected = '';
                        options.each(function () {
                            selected += $(this).text() + ', ';
                        });
                        return selected.substr(0, selected.length - 2);
                    }

                },
                optionLabel: function (element) {
                    return $(element).html();
                },
                onInitialized: function (select, container) {
                    var selectedOptions = $('#department option:selected');

                    var deptId = "";
                    var dropdown = $('#department').siblings('.open');
                    $('#department option').each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                    selectedOptions.each(function () {
                        deptId += $(this).val() + ",";
                    });
                },
                onChange: function (option, checked) {
                    var selectedOptions = $('#department option:selected');
                    var deptId = "";
                    var dropdown = $('#department').siblings('.open');
                    $('#department option').each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });

                    var departments = $('#department option:selected');
                    var selected = [];
                    $(departments).each(function (index, department) {
                        selected.push([$(this).text()]);
                    });
                    $("#departmentName").val(selected.join(","));
                }
            });
        }


        $('#activeTime').multiselect({
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 320,
            numberDisplayed: 2,
            filterPlaceholder: '请输入生效时间',
            includeSelectAllOption: false,
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择生效时间 ';
                } else if (options.length > 5) {
                    return '已选' + options.length + '个 ';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }
            },
            /*  label: function(element) {
             return "<label style='margin-top:7px;'>"+$(element).html()+"</label>";
             }, */
            optionLabel: function (element) {
                return $(element).html();
            },
            /*  optionClass: function(element) {
             return "aa";
             }, */
            onInitialized: function (select, container) {
                var dropdown = $('#activeTime').siblings('.open');
                $('#activeTime option').each(function () {
                    var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                    input.prop('disabled', false);
                    input.parent('li').addClass('disabled');
                });
            },
            onChange: function (option, checked) {
                var dropdown = $('#activeTime').siblings('.open');
                $('#activeTime option').each(function () {
                    var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                    input.prop('disabled', false);
                    input.parent('li').addClass('disabled');
                });

                var activeTimes = $('#activeTime option:selected');
                var selected = [];
                $(activeTimes).each(function (index, activeTime) {
                    selected.push([$(this).text()]);
                });
                $("#activeTimeName").val(selected.join(","));
            }
        });

        $('#source').multiselect({
            includeSelectAllOption: false,
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 320,
            numberDisplayed: 2,
            filterPlaceholder: '请输入来源名',
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择来源 ';
                } else if (options.length > 5) {
                    return '已选' + options.length + '个 ';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }
            },
            /*  label: function(element) {
             return "<label style='margin-top:7px;'>"+$(element).html()+"</label>";
             }, */
            optionLabel: function (element) {
                return $(element).html();
            },
            /*  optionClass: function(element) {
             return "aa";
             }, */
            onInitialized: function (select, container) {
                var dropdown = $('#source').siblings('.open');
                $('#source option').each(function () {
                    var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                    input.prop('disabled', false);
                    input.parent('li').addClass('disabled');
                });
            },
            onChange: function (option, checked) {
                var dropdown = $('#source').siblings('.open');
                $('#source option').each(function () {
                    var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                    input.prop('disabled', false);
                    input.parent('li').addClass('disabled');
                });

                var sources = $('#source option:selected');
                var selected = [];
                $(sources).each(function (index, source) {
                    selected.push([$(this).text()]);
                });
                $("#sourceName").val(selected.join(","));
            }
        });
    });


    function assignBuilding(maxCount) {
        House365Util.createRemoteModal("选择楼盘", "${ctx}/customer/assignBuilding?maxCount="
            + maxCount + "&departmentNames=" + $("#buildingName").val() + "&departmentIds="
            + $("#buildingId").val(), null, function () {
//            var userIds = ",";
//            $("#custom-headers").find("option:selected").each(function () {
//                userIds = userIds + $(this).val() + ",";
//            });
            var buildIds = "", buildNames = "";
            var $buildIds = $("[name='buildId']");
            $buildIds.each(function (n) {
                if (n < ($buildIds.length - 1)) {
                    buildIds = buildIds + $(this).val() + ",";
                } else {
                    buildIds = buildIds + $(this).val()
                }
            });

            var $buildNames = $("[name='buildName']");
            $buildNames.each(function (n) {
                if (n < ($buildNames.length - 1)) {
                    buildNames = buildNames + $(this).val() + ",";
                } else {
                    buildNames = buildNames + $(this).val();
                }
            });

            $("#buildingId").val(buildIds);
            $("#buildingName").val(buildNames);
            return true;
        });
    }

    function formSubmit() {
        console.log($("#buildingId").val())
        if ($("#department").val() == null) {
            House365Util.createModal("请选择", "请选择部门", function () {
            });
            return;
        }
        if ($("#activeTime").val() == null) {
            House365Util.createModal("请选择", "请选择生效时间", function () {
            });
            return;
        }
        if ($("#buildingId").val() == null || $("#buildingId").val() == "") {
            House365Util.createModal("请选择", "请选择楼盘", function () {
            });
            return;
        }
        $('#input_form').submit();
    }
</script>
</body>
</html>