<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>权限组列表</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>权限组列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/role" method="get">
                <input type="text" name="search_LIKE_code" value="${param['search_LIKE_code']}"
                       class="m-wrap small span2" placeholder="编码">
                <input type="text" name="search_LIKE_name" value="${param['search_LIKE_name']}"
                       class="m-wrap small span2" placeholder="名称">
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/role?action=create" class="btn blue pull-right" title="新增"><i class="icon-plus"></i></a>
                </div>
                <div class="buttons pull-right">
                    <a href="javascript:void(0);" onclick="deleteById('')" class="btn blue pull-right" title="删除"><i
                            class="icon-minus"></i></a>
                </div>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center"><input id="memberCheckAll" type="checkbox"
                                                            onclick="checkAll(this)"/></th>
            <th width="100">id</th>
            <th width="100">编码</th>
            <th width="100">名称</th>
            <th width="100">所属部门</th>
            <!-- <th width="100">0 禁用  1 启动</th>
            <th width="100">创建人用户ID</th> -->
            <th width="100">创建人</th>
            <th width="100">创建时间</th>
            <!-- <th width="100">创建人电脑IP</th>
            <th width="100">最后一次修改人用户ID</th>
            <th width="100">最后一次修改人用户名</th>
            <th width="100">最后一次修改时间</th>
            <th width="100">最后一次修改人电脑IP</th> -->
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${roles}" var="role">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${role.id}" onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <a href="${ctx}/role/${role.id}"> <c:if test="${null ne role.id && '' ne role.id}">
                        <c:out value="${role.id}"/>
                    </c:if>
                        <c:if test="${null eq role.id || '' eq role.id}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne role.code && '' ne role.code}">
                        <c:out value="${role.code}"/>
                    </c:if>
                    <c:if test="${null eq role.code || '' eq role.code}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne role.name && '' ne role.name}">
                        <c:out value="${role.name}"/>
                    </c:if>
                    <c:if test="${null eq role.name || '' eq role.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                        <%-- <c:if test="${null ne role.deptName && '' ne role.deptName}">
                            <c:out value="${role.deptName}" />
                        </c:if>
                        <c:if test="${null eq role.deptName || '' eq role.deptName}">
                            &nbsp;
                        </c:if> --%>
                        <%--<a href="${ctx}/department/${role.deptId}">						--%>
                    <c:if test="${null ne role.deptName && '' ne role.deptName}">
                        <c:out value="${role.deptName}"/>
                    </c:if>
                    <c:if test="${null eq role.deptName || '' eq role.deptName}">
                        &nbsp;
                    </c:if>
                        <%--</a>--%>
                </td>
                    <%-- <td nowrap="nowrap">
                            <c:if test="${null ne role.enabled && '' ne role.enabled}">
                                <c:out value="${role.enabled}" />
                            </c:if>
                            <c:if test="${null eq role.enabled || '' eq role.enabled}">
                                &nbsp;
                            </c:if>
                    </td>
                    <td nowrap="nowrap">
                            <c:if test="${null ne role.createUserid && '' ne role.createUserid}">
                                <c:out value="${role.createUserid}" />
                            </c:if>
                            <c:if test="${null eq role.createUserid || '' eq role.createUserid}">
                                &nbsp;
                            </c:if>
                    </td> --%>
                <td nowrap="nowrap">
                    <c:if test="${null ne role.createUsername && '' ne role.createUsername}">
                        <c:out value="${role.createUsername}"/>
                    </c:if>
                    <c:if test="${null eq role.createUsername || '' eq role.createUsername}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne role.createTime && '' ne role.createTime}">
                        <f:formatDate value='${role.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq role.createTime || '' eq role.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                    <%-- <td nowrap="nowrap">
                            <c:if test="${null ne role.createIp && '' ne role.createIp}">
                                <c:out value="${role.createIp}" />
                            </c:if>
                            <c:if test="${null eq role.createIp || '' eq role.createIp}">
                                &nbsp;
                            </c:if>
                    </td>
                    <td nowrap="nowrap">
                            <c:if test="${null ne role.updateUserid && '' ne role.updateUserid}">
                                <c:out value="${role.updateUserid}" />
                            </c:if>
                            <c:if test="${null eq role.updateUserid || '' eq role.updateUserid}">
                                &nbsp;
                            </c:if>
                    </td>
                    <td nowrap="nowrap">
                            <c:if test="${null ne role.updateUsername && '' ne role.updateUsername}">
                                <c:out value="${role.updateUsername}" />
                            </c:if>
                            <c:if test="${null eq role.updateUsername || '' eq role.updateUsername}">
                                &nbsp;
                            </c:if>
                    </td>
                    <td nowrap="nowrap">
                            <c:if test="${null ne role.updateTime && '' ne role.updateTime}">
                                <f:formatDate value='${role.updateTime}' pattern='yyyy-MM-dd HH:mm:ss' />
                            </c:if>
                            <c:if test="${null eq role.updateTime || '' eq role.updateTime}">
                                &nbsp;
                            </c:if>
                    </td>
                    <td nowrap="nowrap">
                            <c:if test="${null ne role.updateIp && '' ne role.updateIp}">
                                <c:out value="${role.updateIp}" />
                            </c:if>
                            <c:if test="${null eq role.updateIp || '' eq role.updateIp}">
                                &nbsp;
                            </c:if>
                    </td> --%>
                <td nowrap="nowrap">
                    <i class="icon-edit pointer icon-large"
                       onclick="window.location='${ctx}/role/${role.id}?action=edit'"></i>
                    &nbsp;&nbsp;
                    <i
                            title="删除"
                            class="icon-minus pointer icon-large"
                            onclick="deleteById('${role.id}')"> </i>
                    &nbsp;&nbsp;
                        <%--  <i
                            title="授权"
                            class=" icon-align-justify pointer icon-large"
                            onclick="authorize(${role.id})"> </i>	 --%>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">
    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    })

    function authorize(id) {
        window.location = "${ctx}/role/authorize/" + id;
    }


    //全选
    function checkAll(btn) {
        console.log(document.all("memberCheck").length);
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除权限组", "请至少选择一条权限组!", function () {
            });
        }
        else {
            House365Util.createModal("删除权限组", "确定要删除该权限组？", function () {
                $.ajax({
                    url: '${ctx}/role/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        alert("该权限组尚有用户，请清空后再进行删除。");
                    }
                });
            });
        }

    };

</script>
</body>
</html>
