<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>权限组管理</title>
    <link href="${ctx}/resources/treeTable/themes/vsStyle/treeTable.min.css" rel="stylesheet" type="text/css"/>
    <script src="${ctx}/resources/treeTable/jquery.treeTable.min.js" type="text/javascript"></script>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/role<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/role">权限组列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="submit"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/role/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/role" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/role/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/role" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">编码:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.code"
                                               name="entity.code"
                                               value="${entity.code}"/>
                                        <font color="red"><form:errors path="roleVo.entity.code"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.code}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">名称:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.name"
                                               name="entity.name"
                                               value="${entity.name}"/>
                                        <font color="red"><form:errors path="roleVo.entity.name"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.name}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <%-- 	<div class="row-fluid">
                            <c:choose>
                                <c:when test="${action!='create' && action!='edit'}">
                                    <div class="span6 control-group">
                                         <label class="control-label">所属部门:</label>
                                         <div class="controls">
                                                    <span class="inline">${entity.deptId}&nbsp;</span>
                                         </div>
                                     </div>
                                </c:when>
                            </c:choose>
                        </div>    --%>
                    <div class="row-fluid">
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">创建人用户名:</label>
                                    <div class="controls">
                                        <span class="inline">${entity.createUsername}&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">创建时间:</label>
                                    <div class="controls">
                                        <span class="inline"><fmt:formatDate type='both' value='${entity.createTime}'
                                                                             pattern='yyyy-MM-dd HH:mm:ss'/>&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                    </div>
                    <div class="row-fluid">
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">最后一次修改人用户名:</label>
                                    <div class="controls">
                                        <span class="inline">${entity.updateUsername}&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">最后一次修改时间:</label>
                                    <div class="controls">
                                        <span class="inline"><fmt:formatDate type='both' value='${entity.updateTime }'
                                                                             pattern='yyyy-MM-dd HH:mm:ss'/>&nbsp;</span>

                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<c:if test="${action!='create'}">
    <div class="row${fluid}">
        <div class="row-fluid">
            <div class="span12">
                <div class="portlet box grey">
                    <div class="portlet-title">
                        <h4> 权限列表 </h4>
                        <c:if test="${action=='edit'}">
                            <div class="tools">
                                <a href="${ctx}/role/authorize/${entity.id}">分配权限</a>
                                <a class="collapse" href="javascript:;"></a>
                            </div>
                        </c:if>
                    </div>
                    <div id="permission_list_container" class="portlet-body lazy-section"
                         base-url="${ctx}/permission/permissionListSection/${entity.id}"></div>
                </div>
            </div>
        </div>
    </div>
</c:if>
</body>

</html>
