<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/reportmarketing<c:if test="${action=='edit'}">/${entity.id}?time=${time}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/reportmarketing/show?time=${time}">直销日报列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="submit"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/reportmarketing/${entity.id}?time=${time}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/reportmarketing/show?time=${time}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/reportmarketing/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/reportmarketing/show?time=${time}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <input type="hidden" id="entity.departmentId" name="entity.departmentId"
                           value="${entity.departmentId}"/>
                    <input type="hidden" id="entity.departmentName" name="entity.departmentName"
                           value="${entity.departmentName}"/>
                    <input type="hidden" id="entity.userId" name="entity.userId"
                           value="${entity.userId}"/>
                    <input type="hidden" id="entity.userName" name="entity.userName"
                           value="${entity.userName}"/>
                    <input type="hidden" id="entity.createTime" name="entity.createTime"
                           value="<fmt:formatDate value="${entity.createTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
                    <input type="hidden" id="entity.reportTime" name="entity.reportTime"
                           value="<fmt:formatDate value="${entity.reportTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"/>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <input type="hidden" id="time" name="time"
                                   value="${time}"/>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <input type="hidden" id="entity.reportTime" name="entity.reportTime"
                                   value="${entity.reportTime}"/>
                        </c:when>
                    </c:choose>
                    <input type="hidden" id="entity.city" name="entity.city"
                           value="${entity.city}"/>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">电话接触量:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="number digits required" maxlength="9"
                                               id="entity.callCount"
                                               name="entity.callCount"
                                               value="${entity.callCount}"/>
                                        <font color="red"><form:errors
                                                path="reportMarketingVo.entity.callCount"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.callCount}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">电话接通量:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="number digits required" maxlength="9"
                                               id="entity.connectCount"
                                               name="entity.connectCount"
                                               value="${entity.connectCount}"/>
                                        <font color="red"><form:errors
                                                path="reportMarketingVo.entity.connectCount"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.connectCount}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">意向沉淀量:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="number digits required" maxlength="9"
                                               id="entity.intentBuyCount"
                                               name="entity.intentBuyCount"
                                               value="${entity.intentBuyCount}"/>
                                        <font color="red"><form:errors
                                                path="reportMarketingVo.entity.intentBuyCount"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.intentBuyCount}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>

                        <div class="span6 control-group">
                                <label class="control-label">业绩:</label>
                                <div class="controls">
                                    <c:choose>
                                        <c:when test="${action=='create' || action=='edit'}">
                                            <input type="text" class="number digits required" maxlength="9"
                                                   id="entity.source"
                                                   name="entity.source"
                                                   value="${entity.source}"/>
                                            <font color="red"><form:errors
                                                    path="reportMarketingVo.entity.source"/></font>
                                        </c:when>
                                        <c:otherwise>
                                            <span class="inline">${entity.source}&nbsp;</span>
                                        </c:otherwise>
                                    </c:choose>
                                </div>
                         </div>
                    </div>

                    <div class="row-fluid">

                        <div class="span6 control-group">
                            <label class="control-label">到访量:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="number digits required" maxlength="9"
                                               id="entity.visitedCount"
                                               name="entity.visitedCount"
                                               value="${entity.visitedCount}"/>
                                        <font color="red"><form:errors
                                                path="reportMarketingVo.entity.visitedCount"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.visitedCount}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>

                        <div class="span6 control-group">
                            <label class="control-label">到访项目:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="required" maxlength="140"
                                               id="entity.visitedProject"
                                               name="entity.visitedProject"
                                               value="${entity.visitedProject}"/>
                                        <font color="red"><form:errors
                                                path="reportMarketingVo.entity.visitedProject"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.visitedProject}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">二访量:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="number digits required" maxlength="9"
                                               id="entity.twiceVisitedCount"
                                               name="entity.twiceVisitedCount"
                                               value="${entity.twiceVisitedCount}"/>
                                        <font color="red"><form:errors
                                                path="reportMarketingVo.entity.twiceVisitedCount"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.twiceVisitedCount}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>

                        <div class="span6 control-group">
                            <label class="control-label">二访项目:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="required" maxlength="140"
                                               id="entity.twiceVisitedProject"
                                               name="entity.twiceVisitedProject"
                                               value="${entity.twiceVisitedProject}"/>
                                        <font color="red"><form:errors
                                                path="reportMarketingVo.entity.twiceVisitedProject"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.twiceVisitedProject}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">认筹量:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="number digits required" maxlength="9"
                                               id="entity.identificationChipsCount"
                                               name="entity.identificationChipsCount"
                                               value="${entity.identificationChipsCount}"/>
                                        <font color="red"><form:errors
                                                path="reportMarketingVo.entity.identificationChipsCount"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.identificationChipsCount}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">认筹项目:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="required" id="entity.identificationChipsProject"
                                               name="entity.identificationChipsProject"
                                               value="${entity.identificationChipsProject}" maxlength="140"/>
                                        <font color=" red"><form:errors
                                            path="reportMarketingVo.entity.identificationChipsProject"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.identificationChipsProject}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">认购量:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="number digits required" maxlength="9"
                                               id="entity.subscriptionCount"
                                               name="entity.subscriptionCount"
                                               value="${entity.subscriptionCount}"/>
                                        <font color="red"><form:errors
                                                path="reportMarketingVo.entity.subscriptionCount"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.subscriptionCount}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">认购项目:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" class="required" id="entity.subscriptionProject"
                                               name="entity.subscriptionProject"
                                               value="${entity.subscriptionProject}" maxlength="140"/>
                                        <font color="red"><form:errors
                                                path="reportMarketingVo.entity.subscriptionProject"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.subscriptionProject}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
</body>

</html>