<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>置业报告</title>
    <link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-3.0.3.min.css">
    <style>
        * {
            padding: 0;
            margin: 0;
        }

        .user-list {
            padding: 20px;
        }

        .user-list .form-inline .form-group {
            vertical-align: inherit !important;
            margin: 10px 0;
        }

        .user-list .form-control {
            width: inherit;
        }

        .m_l30 {
            margin-left: 30px;
        }

        .col_f5f5f5 {
            background-color: #f5f5f5;
        }

        .user-list label {
            display: inline-block;
            margin-bottom: 5px;
            font-weight: inherit;
        }

        .ft_w {
            font-weight: bolder !important;
        }

        .user-list .form-control {
            height: 25px;
            width: 100px;
        }

        .user_table {
            margin-top: 21px;
        }

        .user_table th, td {
            text-align: center !important;
        }

        .tex_c {
            text-align: center;
        }

        button {
            outline: none;
            border: none !important;
        }

        #myModal05 .modal-dialog {
            width: 1000px;
            margin: 150px auto !important;
        }

        .btn:hover,
        .btn:focus {
            outline: none;
        }

        .modal {
            position: fixed;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            z-index: 1040;
            display: none;
            overflow: hidden;
            overflow-y: hidden;
            width: 1000px;
            background-color: inherit;
            box-shadow: none;
            border: none;
        }

        .modal.fade.in {
            margin: 0 auto;
        }

        .td {
            text-align: center;
        }

        .collapse {
            display: block !important;
        }

        .navbar .nav {
            margin-top: 6px !important;
        }

        .chosen-container {
            margin-top: 6px !important;
        }
    </style>
</head>
<body>
<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>概览
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>修改置业报告
            </li>
        </ul>
    </div>
</div>

<div class="user-list">
    <div>
        <label class="ft_w">用户信息</label>
    </div>
    <form class="form-inline ">
        <div class="form-group">
            <label>用户手机号码：</label>
            <input type="text" class="form-control" id="phone" style="width: 150px" placeholder=""
                   value="${data.phone}"
                   readonly>
        </div>
        <div class="form-group ">
            <label class="m_l30">姓名：</label>
            <input type="text" class="form-control" id="customerName" placeholder="" value="${data.name}" readonly>
        </div>
        <div class="form-group ">
            <label class="control-label m_l30">性别：</label>
            <label class="radio-inline">
                <input type="radio" name="sex" value="0">先生
            </label>
            <label class="radio-inline">
                <input type="radio" name="sex" value="1">女士
            </label>
        </div>

        <div>
            <label class="ft_w">用户诉求</label>
        </div>

        <div class="form-group">
            <label>总价：</label>
            <input type="text" id="lowPrice" class="form-control" onKeyUp="this.value=this.value.replace(/\D/g,'')"
                   onafterpaste="this.value=this.value.replace(/\D/g,'')">
            <span>--</span>
            <input type="text" id="highPrice" class="form-control" onKeyUp="this.value=this.value.replace(/\D/g,'')"
                   onafterpaste="this.value=this.value.replace(/\D/g,'')">
            <span>万元</span>
        </div>
        <div class="form-group ">
            <label class="m_l30">首付：</label>
            <input type="text" class="form-control" id="lowDownPayment"
                   onKeyUp="this.value=this.value.replace(/\D/g,'')"
                   onafterpaste="this.value=this.value.replace(/\D/g,'')">
            <span>--</span>
            <input type="text" class="form-control" id="highDownPayment"
                   onKeyUp="this.value=this.value.replace(/\D/g,'')"
                   onafterpaste="this.value=this.value.replace(/\D/g,'')">
            <span>万元</span>
        </div>
        <div class="form-group ">
            <label class="m_l30">面积：</label>
            <input type="text" class="form-control" id="lowArea" onKeyUp="this.value=this.value.replace(/\D/g,'')"
                   onafterpaste="this.value=this.value.replace(/\D/g,'')">
            <span>--</span>
            <input type="text" class="form-control" id="highArea" onKeyUp="this.value=this.value.replace(/\D/g,'')"
                   onafterpaste="this.value=this.value.replace(/\D/g,'')">
            <span>㎡</span>
        </div>
        <div>
            <label>楼盘类型：</label>
            <div class="form-group">
                <%--channel： 1住宅 2写字楼 3别墅 4商业 5公寓--%>
                <label class="checkbox-inline">
                    <input type="checkbox" name="channel" value="1">住宅
                </label>
                <label class="checkbox-inline">
                    <input type="checkbox" name="channel" value="5">公寓
                </label>
                <label class="checkbox-inline">
                    <input type="checkbox" name="channel" value="4">商铺
                </label>
                <label class="checkbox-inline">
                    <input type="checkbox" name="channel" value="2">写字楼
                </label>
                <label class="checkbox-inline">
                    <input type="checkbox" name="channel" value="3">别墅
                </label>
            </div>

            <div class="form-group">
                <label class="m_l30">居室：</label>
                <label class="checkbox-inline">
                    <input type="checkbox" name="roomType" value="1">1居室
                </label>
                <label class="checkbox-inline">
                    <input type="checkbox" name="roomType" value="2">2居室
                </label>
                <label class="checkbox-inline">
                    <input type="checkbox" name="roomType" value="3">3居室
                </label>
                <label class="checkbox-inline">
                    <input type="checkbox" name="roomType" value="4">4居室
                </label>
                <label class="checkbox-inline">
                    <input type="checkbox" name="roomType" value="5">5居室及以上
                </label>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label">资质：</label>
            <label class="radio-inline">
                <input type="radio" name="hasAttach" value="1">有
            </label>
            <label class="radio-inline">
                <input type="radio" name="hasAttach" value="0">无
            </label>
            <label class="control-label m_l30">购房目的：</label>
            <label class="radio-inline">
                <input type="radio" name="buyPurpose" value="1">刚需
            </label>
            <label class="radio-inline">
                <input type="radio" name="buyPurpose" value="2">置换
            </label>
            <label class="radio-inline">
                <input type="radio" name="buyPurpose" value="3">学区
            </label>
            <label class="radio-inline">
                <input type="radio" name="buyPurpose" value="4">投资
            </label>
        </div>
        <br>
        <div class="form-group" id="disHtml">

        </div>
        <br>
        <div class="form-group">
            <label class="control-label ">是否贷款：</label>
            <label class="radio-inline">
                <input type="radio" name="isLoan" value="1">是
            </label>
            <label class="radio-inline">
                <input type="radio" name="isLoan" value="0">否
            </label>
            <label class="m_l30">首付比例：</label>
            <input type="text" class="form-control" id="downPaymentRatio"
                   onKeyUp="this.value=this.value.replace(/\D/g,'')"
                   onafterpaste="this.value=this.value.replace(/\D/g,'')">%
        </div>
    </form>
    <button type="button" class="btn btn-primary" onclick="searchHouse()">查询楼盘户型</button>
    <hr>
    <button type="button" class="btn btn-primary addhx" data-toggle="modal" data-target="#myModal05"
            onclick="showModalNew()">添加户型
    </button>

    <div style="margin-top: 20px;">
        <span>原楼盘：</span>
    </div>
    <table class="table table-bordered table-hover user_table">
        <thead>
        <tr class="col_f5f5f5">
            <th><input type="checkbox" onclick="checkAll3(this)"/></th>
            <th>顺序</th>
            <th>楼盘名称</th>
            <th>是否直销楼盘</th>
            <th>区属</th>
            <th>户型</th>
            <th>面积(㎡)</th>
            <th>单价</th>
            <th>首付(万)</th>
            <th>月供(万)</th>
            <th>总价(万)</th>
            <th>销售状态</th>
            <th>排序</th>
        </tr>
        </thead>
        <tbody id="houseOldHtml">

        </tbody>
    </table>

    <span>添加楼盘：</span>
    <table class="table table-bordered table-hover user_table">
        <thead>
        <tr class="col_f5f5f5">
            <th><input type="checkbox" onclick="checkAll2(this)"/></th>
            <th>顺序</th>
            <th>楼盘名称</th>
            <th>是否直销楼盘</th>
            <th>区属</th>
            <th>户型</th>
            <th>面积(㎡)</th>
            <th>单价</th>
            <th>首付(万)</th>
            <th>月供(万)</th>
            <th>总价(万)</th>
            <th>销售状态</th>
            <th>排序</th>
        </tr>
        </thead>
        <tbody id="houseAddHtml">

        </tbody>
    </table>

    <span>查询楼盘：</span>
    <table class="table table-bordered table-hover user_table">
        <thead>
        <tr class="col_f5f5f5">
            <th><input type="checkbox" onclick="checkAll(this)"/></th>
            <th>顺序</th>
            <th>楼盘名称</th>
            <th>是否直销楼盘</th>
            <th>区属</th>
            <th>户型</th>
            <th>面积(㎡)</th>
            <th>单价</th>
            <th>首付(万)</th>
            <th>月供(万)</th>
            <th>总价(万)</th>
            <th>销售状态</th>
            <th>排序</th>
        </tr>
        </thead>
        <tbody id="houseHtml">

        </tbody>
    </table>
    <div class="tex_c">
        <button type="button" style="border-radius: 20px;width: 150px" class="btn btn-primary"
                onclick="saveReport()">
            生成报告
        </button>
    </div>
</div>

<!-- 模态框（Modal） -->
<div class="modal fade " id="myModal05" tabindex="-1" role="dialog" aria-labelledby="myModal05Label"
     aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
                <h4 class="modal-title" id="myModal05Label">
                    添加户型
                </h4>
            </div>
            <div class="modal-body">
                <form class="form-inline ">
                    <div class="form-group">
                        <label>楼盘：</label>
                        <input type="text" class="form-control" id="houseName" style="width: 200px"
                               placeholder="">
                        <button type="button" class="btn btn-primary"
                                style="height: 25px;line-height: 13px;width: 80px" onclick="searchByName()">查询
                        </button>
                    </div>
                </form>
                <table class="table table-bordered table-hover user_table">
                    <thead>
                    <tr class="col_f5f5f5">
                        <th><input type="checkbox" onclick="checkAll1(this)"/></th>
                        <%--<th>顺序</th>--%>
                        <th>楼盘名称</th>
                        <th>是否直销楼盘</th>
                        <th>区属</th>
                        <th>户型</th>
                        <th>面积(㎡)</th>
                        <th>单价</th>
                        <th>首付(万)</th>
                        <th>月供(万)</th>
                        <th>总价(万)</th>
                        <th>销售状态</th>
                    </tr>
                    </thead>
                    <tbody id="houseNameHtml">

                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default close_model" data-dismiss="modal">关闭
                </button>
                <button type="button" class="btn btn-primary" onclick="addHouse()">
                    添加
                </button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal -->
</div>

<script>

    var showModalNew = function () {
        var htmlNew = "";
        $("#houseNameHtml").html(htmlNew);
        $(".modal").show();
        $(".borNone").css("z-index","99999")
    };

    $('#myModal05').on('hidden.bs.modal', function () {
        $(".modal").hide();
        $(".borNone").css("z-index","-999")
    });

    $(".close_model").on("click", function () {
        $(".modal").hide();
        $(".borNone").css("z-index","-999")
    });
    $(".close").on("click", function () {
        $(".modal").hide();
        $(".borNone").css("z-index","-999")
    });

    $(function () {
        function getCityConf() {
            $.ajax({
                url: ctx + '/propertyreport/getCityConf',
                method: 'get',
                contentType: "application/x-www-form-urlencoded; charset=UTF-8",
                dataType: 'json',
                async: false,
                success: function (data) {
                    if (data.status == 0) {
                        var disHtml = "<label for=''>区属：</label>";
                        for (var i = 0; i < data.data.length; i++) {
                            var dis = data.data[i];
                            var value = dis.id + "-" + dis.name;
                            disHtml += "<label class='checkbox-inline'>";
                            disHtml += "<input type='checkbox' name='district' value='" + value + "'" + "'>" + dis.name;
                            disHtml += "</label>";
                        }
                        $("#disHtml").html(disHtml);
                    } else {
                        alert(data.errorMessage);
                    }
                }
            });
        }

        getCityConf();

        function getHouse() {
            var id = ${report.id};
            $.ajax({
                url: ctx + '/propertyreport/getHouse/' + id,
                method: 'get',
                contentType: "application/x-www-form-urlencoded; charset=UTF-8",
                dataType: 'json',
                async: false,
                success: function (data) {
                    if (data.status == 0) {
                        var houseOldHtml = "";
                        oldHouseArray = data.data;
                        for (var j = 0; j < data.data.length; j++) {
                            var index = j + 1;
                            var house = data.data[j];
                            if (house.isDirect == 1) {
                                houseOldHtml += '<tr style="color:red !important">';
                            } else {
                                houseOldHtml += '<tr>';
                            }
                            houseOldHtml += "<td>" + "<input type='checkbox' name='memberCheck3' value='" + j + "'>" + "</td>";
                            houseOldHtml += "<td>" + index + "</td>";
                            houseOldHtml += "<td>" + house.houseName + "</td>";
                            if (house.isDirect == 1) {
                                houseOldHtml += "<td>" + "是" + "</td>";
                            } else {
                                houseOldHtml += "<td>" + "否" + "</td>";
                            }
                            houseOldHtml += "<td>" + house.district + "</td>";
                            houseOldHtml += "<td>" + house.unitType + "</td>";
                            houseOldHtml += "<td>" + house.area + "</td>";
                            houseOldHtml += "<td>" + house.averagePrice + "</td>";

                            houseOldHtml += "<td>" + house.downPayment + "</td>";
                            houseOldHtml += "<td>" + house.monthPay + "</td>";
                            houseOldHtml += "<td>" + house.totalPrice + "</td>";
                            houseOldHtml += "<td>" + house.isSell + "</td>";
                            var id = "orderOldNo" + index;
                            var value = house.orderNo;
                            houseOldHtml += "<td>" + "<input style='width: 100px'  type='number' name='orderNo'" + " id ='" + id + "'"+ " value ='" + value + "'" + ">" + "</td>";
                            houseOldHtml += "</tr>";
                        }
                        $("#houseOldHtml").html(houseOldHtml);
                    } else {
                        alert(data.errorMessage);
                    }
                }
            });
        }

        getHouse();
        var oldSex = ${report.sex};
        var totalPriceMin = ${report.totalPriceMin};
        var totalPriceMax = ${report.totalPriceMax};
        var downPaymentMin = ${report.downPaymentMin};
        var downPaymentMax = ${report.downPaymentMax};
        var areaMin = ${report.areaMin};
        var areaMax = ${report.areaMax};
        var channel = ${report.channel};
        var roomType = ${report.roomType};

        var hasAttach = ${report.hasAttach};
        var buyPurpose = ${report.buyPurpose};
        var isLoan = ${report.isLoan};
        var downPaymentRatio = ${report.downPaymentRatio};
        var district = ${report.districtId};
        if (oldSex == 0) {
            $("input[name='sex'][value='0']").prop('checked', true);
        } else if (oldSex == 1) {
            $("input[name='sex'][value='1']").prop('checked', true);
        }
        if (hasAttach == 0) {
            $("input[name='hasAttach'][value='0']").prop('checked', true);
        } else if (hasAttach == 1) {
            $("input[name='hasAttach'][value='1']").prop('checked', true);
        }
        if (isLoan == 0) {
            $("input[name='isLoan'][value='0']").prop('checked', true);
        } else if (isLoan == 1) {
            $("input[name='isLoan'][value='1']").prop('checked', true);
        }
        if (buyPurpose == 1) {
            $("input[name='buyPurpose'][value='1']").prop('checked', true);
        } else if (buyPurpose == 2) {
            $("input[name='buyPurpose'][value='2']").prop('checked', true);
        } else if (buyPurpose == 3) {
            $("input[name='buyPurpose'][value='3']").prop('checked', true);
        } else if (buyPurpose == 4) {
            $("input[name='buyPurpose'][value='4']").prop('checked', true);
        }
        $("#lowPrice").val(totalPriceMin);
        $("#highPrice").val(totalPriceMax);
        $("#lowDownPayment").val(downPaymentMin);
        $("#highDownPayment").val(downPaymentMax);
        $("#lowArea").val(areaMin);
        $("#highArea").val(areaMax);
        $("#downPaymentRatio").val(downPaymentRatio);
        $(channel).each(function (i, dom) {
            $(":checkbox[name='channel'][value='" + dom + "']").prop("checked", true);
        });
        $(roomType).each(function (i, dom) {
            $(":checkbox[name='roomType'][value='" + dom + "']").prop("checked", true);
        });
        $(district).each(function (i, dom) {
            $(":checkbox[name='district'][value='" + dom + "']").prop("checked", true);
        });
    });

    var houseArray = [];
    var houseNameArray = [];
    var addHouseArray = [];
    var oldHouseArray = [];
    var searchHouse = function () {
        var lowPrice = $("#lowPrice").val();
        var highPrice = $("#highPrice").val();
        var lowDownPayment = $("#lowDownPayment").val();
        var highDownPayment = $("#highDownPayment").val();
        var lowArea = $("#lowArea").val();
        var highArea = $("#highArea").val();
        var channels = [];
        $('input[name="channel"]:checked').each(function () {
            channels.push($(this).val());
        });
        if (channels.length === 0) {
            alert("请选择楼盘类型");
            return;
        }
        if (channels.length > 3) {
            alert("楼盘类型最多选择3个");
            return;
        }
        var channel = channels.join(",");
        var roomTypes = [];
        $('input[name="roomType"]:checked').each(function () {
            roomTypes.push($(this).val());
        });
        if (roomTypes.length === 0) {
            alert("请选择居室");
            return;
        }
        if (roomTypes.length > 3) {
            alert("居室最多选择3个");
            return;
        }
        var roomType = roomTypes.join(",");
        var hasAttach = $("input[name='hasAttach']:checked").val();
        var buyPurpose = $("input[name='buyPurpose']:checked").val();
        var isLoan = $("input[name='isLoan']:checked").val();
        var downPaymentRatio = $("#downPaymentRatio").val();
        var districts = [];
        $('input[name="district"]:checked').each(function () {
            districts.push($(this).val());
        });
        if (districts.length === 0) {
            alert("请选择区属");
            return;
        }
        if (districts.length > 3) {
            alert("区属最多选择3个");
            return;
        }
        var district = districts.join(",");
        if (typeof(lowPrice) == "undefined" || lowPrice == '' || lowPrice == null) {
            alert("请输入正确的楼盘总价");
            return;
        }
        if (typeof(highPrice) == "undefined" || highPrice == '' || highPrice == null) {
            alert("请输入正确的楼盘总价");
            return;
        }
        if (parseInt(lowPrice) >= parseInt(highPrice)) {
            alert("请输入正确的楼盘总价");
            return;
        }
        if (typeof(lowDownPayment) == "undefined" || lowDownPayment == '' || lowDownPayment == null) {
            alert("请输入正确的首付");
            return;
        }
        if (typeof(highDownPayment) == "undefined" || highDownPayment == '' || highDownPayment == null) {
            alert("请输入正确的首付");
            return;
        }
        if (parseInt(lowDownPayment) >= parseInt(highDownPayment)) {
            alert("请输入正确的首付");
            return;
        }
        if (typeof(lowArea) == "undefined" || lowArea == '' || lowArea == null) {
            alert("请输入正确的面积");
            return;
        }
        if (typeof(highArea) == "undefined" || highArea == '' || highArea == null) {
            alert("请输入正确的面积");
            return;
        }
        if (parseInt(lowArea) >= parseInt(highArea)) {
            alert("请输入正确的面积");
            return;
        }
        var data = {
            totalPriceMin: lowPrice,
            totalPriceMax: highPrice,
            downPaymentMin: lowDownPayment,
            downPaymentMax: highDownPayment,
            areaMin: lowArea,
            areaMax: highArea,
            channel: channel,
            roomType: roomType,
            district: district,
            isLoan: isLoan,
            downPaymentRatio: downPaymentRatio
        };
        data = JSON.stringify(data);
        $.ajax({
            url: '${ctx}/propertyreport/searchHouse/1',
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (data) {
                if (data.status == 0) {
                    houseArray = data.data;
                    var houseHtml = "";
                    for (var i = 0; i < data.data.length; i++) {
                        var house = data.data[i];
                        var index = i + 1;
                        if (house.is_zx == 1) {
                            houseHtml += '<tr style="color:red !important">';
                        } else {
                            houseHtml += '<tr>';
                        }
                        houseHtml += "<td>" + "<input type='checkbox' name='memberCheck' value='" + i + "'>" + "</td>";
                        houseHtml += "<td>" + index + "</td>";
                        houseHtml += "<td>" + house.itemname + "</td>";
                        if (house.is_zx == 1) {
                            houseHtml += "<td>" + "是" + "</td>";
                        } else {
                            houseHtml += "<td>" + "否" + "</td>";
                        }
                        houseHtml += "<td>" + house.prj_dist_name + "</td>";
                        houseHtml += "<td>" + house.room + "</td>";
                        houseHtml += "<td>" + house.pic_area + "</td>";
                        houseHtml += "<td>" + house.price_show + "</td>";
                        var totalPrice = house.pic_hx_totalprice;

                        houseHtml += "<td>" + house.downPayment + "</td>";
                        houseHtml += "<td>" + house.monthPay + "</td>";
                        houseHtml += "<td>" + totalPrice + "</td>";
                        houseHtml += "<td>" + house.sale + "</td>";
                        var id = "orderHouseNo" + index;
                        houseHtml += "<td>" + "<input style='width: 100px' type='number' name='orderNo' id ='" + id + "'" + ">" + "</td>";
                        houseHtml += "</tr>";
                    }
                    $("#houseHtml").html(houseHtml);
                } else {
                    alert(data.errorMessage);
                }
            }
        });

    };

    var saveReport = function () {
        var indexs = [];
        var addIndexs = [];
        var oldIndexs = [];
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                indexs.push(document.getElementsByName('memberCheck')[i].value);
            }
        }
        for (i = 0; i < document.getElementsByName('memberCheck2').length; i++) {
            if (document.getElementsByName('memberCheck2')[i].checked) {
                addIndexs.push(document.getElementsByName('memberCheck2')[i].value);
            }
        }
        for (i = 0; i < document.getElementsByName('memberCheck3').length; i++) {
            if (document.getElementsByName('memberCheck3')[i].checked) {
                oldIndexs.push(document.getElementsByName('memberCheck3')[i].value);
            }
        }
        if (indexs.length == 0 && addIndexs.length == 0 && oldIndexs.length == 0) {
            alert("请至少选择一个楼盘!");
            return false;
        }
        var id = ${report.id};
        var phone = $("#phone").val();
        var customerId = ${data.id};
        var customerName = $("#customerName").val();
        var sex = $("input[name='sex']:checked").val();
        var lowPrice = $("#lowPrice").val();
        var highPrice = $("#highPrice").val();

        var lowDownPayment = $("#lowDownPayment").val();
        var highDownPayment = $("#highDownPayment").val();
        var lowArea = $("#lowArea").val();
        var highArea = $("#highArea").val();
        var channels = [];
        $('input[name="channel"]:checked').each(function () {
            channels.push($(this).val());
        });
        if (channels.length === 0) {
            alert("请选择楼盘类型");
            return;
        }
        var channel = channels.join(",");
        var roomTypes = [];
        $('input[name="roomType"]:checked').each(function () {
            roomTypes.push($(this).val());
        });
        if (roomTypes.length === 0) {
            alert("请选择居室");
            return;
        }
        var roomType = roomTypes.join(",");
        var hasAttach = $("input[name='hasAttach']:checked").val();
        var buyPurpose = $("input[name='buyPurpose']:checked").val();
        var isLoan = $("input[name='isLoan']:checked").val();
        var downPaymentRatio = $("#downPaymentRatio").val();
        var districts = [];
        $('input[name="district"]:checked').each(function () {
            districts.push($(this).val());
        });
        if (districts.length === 0) {
            alert("请选择区属");
            return;
        }
        var district = districts.join(",");
        if (typeof(customerName) == "undefined" || customerName == '' || customerName == null) {
            alert("请填写姓名");
            return;
        }
        if (typeof(sex) == "undefined" || sex == '' || sex == null) {
            alert("请填写性别");
            return;
        }
        if (typeof(lowPrice) == "undefined" || lowPrice == '' || lowPrice == null) {
            alert("请输入正确的楼盘总价");
            return;
        }
        if (typeof(highPrice) == "undefined" || highPrice == '' || highPrice == null) {
            alert("请输入正确的楼盘总价");
            return;
        }
        if (parseInt(lowPrice) >= parseInt(highPrice)) {
            alert("请输入正确的楼盘总价");
            return;
        }
        if (typeof(lowDownPayment) == "undefined" || lowDownPayment == '' || lowDownPayment == null) {
            alert("请输入正确的首付");
            return;
        }
        if (typeof(highDownPayment) == "undefined" || highDownPayment == '' || highDownPayment == null) {
            alert("请输入正确的首付");
            return;
        }
        if (parseInt(lowDownPayment) >= parseInt(highDownPayment)) {
            alert("请输入正确的首付");
            return;
        }
        if (typeof(lowArea) == "undefined" || lowArea == '' || lowArea == null) {
            alert("请输入正确的面积");
            return;
        }
        if (typeof(highArea) == "undefined" || highArea == '' || highArea == null) {
            alert("请输入正确的面积");
            return;
        }
        if (parseInt(lowArea) >= parseInt(highArea)) {
            alert("请输入正确的面积");
            return;
        }
        if (typeof(hasAttach) == "undefined" || hasAttach == '' || hasAttach == null) {
            alert("请选择资质");
            return;
        }
        if (typeof(buyPurpose) == "undefined" || buyPurpose == '' || buyPurpose == null) {
            alert("请选择购房目的");
            return;
        }
        if (typeof(isLoan) == "undefined" || isLoan == '' || isLoan == null) {
            alert("请选择是否贷款");
            return;
        }
        if (typeof(downPaymentRatio) == "undefined" || downPaymentRatio == '' || downPaymentRatio == null) {
            alert("请输入首付比例");
            return;
        }
        var ratio = parseInt(downPaymentRatio);
        if (ratio > 100) {
            alert("请输入正确的首付比例");
            return;
        }
        var saveHouseArray = [];
        for (var i = 0; i < indexs.length; i++) {
            var index = indexs[i];
            var noIndex = parseInt(index) + 1;
            var orderId = "orderHouseNo" + noIndex;
            var orderNo = $("#" + orderId + "").val();
            if (typeof(orderNo) != "undefined" && orderNo != '' && orderNo != null) {
                if (!isPInt(orderNo)) {
                    alert("排序值必须大于等于1")
                    return;
                }
            }
            houseArray[index].orderNo = orderNo;
            saveHouseArray.push(houseArray[index]);
        }
        for (var i = 0; i < addIndexs.length; i++) {
            var index = addIndexs[i];
            var noIndex = parseInt(index) + 1;
            var orderId = "orderAddNo" + noIndex;
            var orderNo = $("#" + orderId + "").val();
            if (typeof(orderNo) != "undefined" && orderNo != '' && orderNo != null) {
                if (!isPInt(orderNo)) {
                    alert("排序值必须大于等于1")
                    return;
                }
            }
            addHouseArray[index].orderNo = orderNo;
            saveHouseArray.push(addHouseArray[index]);
        }
        var oldArrays = [];
        for (var i = 0; i < oldIndexs.length; i++) {
            var index = oldIndexs[i];
            var noIndex = parseInt(index) + 1;
            var orderId = "orderOldNo" + noIndex;
            var orderNo = $("#" + orderId + "").val();
            if (typeof(orderNo) != "undefined" && orderNo != '' && orderNo != null) {
                if (!isPInt(orderNo)) {
                    alert("排序值必须大于等于1")
                    return;
                }
            }
            oldHouseArray[index].orderNo = orderNo;
            oldArrays.push(oldHouseArray[index]);
        }
        var list = [];
        for (i = 0; i < saveHouseArray.length; i++) {
            var houseEntity = {
                relateId: '',
                houseName: '',
                projectId: '',
                channel: '',
                isDirect: '',
                district: '',
                unitType: '',
                area: '',
                unitPrice: '',
                downPayment: '',
                monthPay: '',
                totalPrice: '',
                isSell: '',
                property: '',
                decoration: '',
                volumeRate: '',
                parkMatch: '',
                averagePrice: '',
                deliveryTime: '',
                goods: '',
                imageUrl: '',
                orderNo: '',
                houseUrl:'',
            };
            houseEntity.relateId = customerId;
            houseEntity.houseName = saveHouseArray[i].itemname;
            houseEntity.projectId = parseInt(saveHouseArray[i].prj_id);
            houseEntity.channel = parseInt(saveHouseArray[i].pic_channel);
            houseEntity.isDirect = parseInt(saveHouseArray[i].is_zx);
            houseEntity.district = saveHouseArray[i].prj_dist_name;
            houseEntity.unitType = saveHouseArray[i].room;
            houseEntity.area = saveHouseArray[i].pic_area;
            houseEntity.unitPrice = saveHouseArray[i].price_show;
            houseEntity.downPayment = saveHouseArray[i].downPayment.toString();
            houseEntity.monthPay = saveHouseArray[i].monthPay.toString();
            houseEntity.totalPrice = saveHouseArray[i].pic_hx_totalprice;
            houseEntity.isSell = saveHouseArray[i].sale;
            houseEntity.property = saveHouseArray[i].wygs;
            houseEntity.decoration = saveHouseArray[i].prj_decorate;
            houseEntity.volumeRate = saveHouseArray[i].prj_cubagerate;
            houseEntity.parkMatch = saveHouseArray[i].chwb;
            houseEntity.averagePrice = saveHouseArray[i].price_show;
            houseEntity.deliveryTime = saveHouseArray[i].jiaofu_time;
            houseEntity.goods = saveHouseArray[i].pic_content;
            houseEntity.imageUrl = saveHouseArray[i].pic_address;
            houseEntity.orderNo = parseInt(saveHouseArray[i].orderNo);
            houseEntity.houseUrl = saveHouseArray[i].prj_link;
            list.push(houseEntity);
        }
        for (i = 0; i < oldArrays.length; i++) {
            var houseEntity = {
                relateId: '',
                houseName: '',
                projectId: '',
                channel: '',
                isDirect: '',
                district: '',
                unitType: '',
                area: '',
                unitPrice: '',
                downPayment: '',
                monthPay: '',
                totalPrice: '',
                isSell: '',
                property: '',
                decoration: '',
                volumeRate: '',
                parkMatch: '',
                averagePrice: '',
                deliveryTime: '',
                goods: '',
                imageUrl: '',
                orderNo: '',
                houseUrl:'',
            };
            houseEntity.relateId = customerId;
            houseEntity.houseName = oldArrays[i].houseName;
            houseEntity.projectId = parseInt(oldArrays[i].projectId);
            houseEntity.channel = parseInt(oldArrays[i].channel);
            houseEntity.isDirect = parseInt(oldArrays[i].isDirect);
            houseEntity.district = oldArrays[i].district;
            houseEntity.unitType = oldArrays[i].unitType;
            houseEntity.area = oldArrays[i].area;
            houseEntity.unitPrice = oldArrays[i].averagePrice;
            houseEntity.downPayment = oldArrays[i].downPayment.toString();
            houseEntity.monthPay = oldArrays[i].monthPay.toString();
            houseEntity.totalPrice = oldArrays[i].totalPrice;
            houseEntity.isSell = oldArrays[i].isSell;
            houseEntity.property = oldArrays[i].property;
            houseEntity.decoration = oldArrays[i].decoration;
            houseEntity.volumeRate = oldArrays[i].volumeRate;
            houseEntity.parkMatch = oldArrays[i].parkMatch;
            houseEntity.averagePrice = oldArrays[i].averagePrice;
            houseEntity.deliveryTime = oldArrays[i].deliveryTime;
            houseEntity.goods = oldArrays[i].goods;
            houseEntity.imageUrl = oldArrays[i].imageUrl;
            houseEntity.orderNo = parseInt(oldArrays[i].orderNo);
            houseEntity.houseUrl = oldArrays[i].houseUrl;
            list.push(houseEntity);
        }
        var entity = {
            id: id,
            phone: phone,
            customerName: customerName,
            customerId: customerId,
            sex: parseInt(sex),
            totalPriceMin: parseInt(lowPrice),
            totalPriceMax: parseInt(highPrice),
            downPaymentMin: parseInt(lowDownPayment),
            downPaymentMax: parseInt(highDownPayment),
            areaMin: parseInt(lowArea),
            areaMax: parseInt(highArea),
            channel: channel,
            roomType: roomType,
            district: district,
            isLoan: parseInt(isLoan),
            downPaymentRatio: parseInt(downPaymentRatio),
            hasAttach: parseInt(hasAttach),
            buyPurpose: parseInt(buyPurpose)
        };

        var data = {
            entity: entity,
            list: list
        };
        data = JSON.stringify(data);
        $.ajax({
            url: '${ctx}/propertyreport/update',
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    alert("修改成功！");
                    addHouseArray = [];
                    var url = "/house365-hgs-web/propertyreport/list"
                    window.location.href = url;
                } else {
                    addHouseArray = [];
                    alert(result.errorMessage);
                }
            }
        });
    };

    var addHouse = function () {
        var indexs = [];
        for (i = 0; i < document.getElementsByName('memberCheck1').length; i++) {
            if (document.getElementsByName('memberCheck1')[i].checked) {
                indexs.push(document.getElementsByName('memberCheck1')[i].value);
            }
        }
        if (indexs.length == 0) {
            alert("请至少选择一个楼盘!");
            return false;
        }
        for (var i = 0; i < indexs.length; i++) {
            var index = indexs[i];
            addHouseArray.push(houseNameArray[index]);
        }
        var houseAddHtml = "";
        for (var j = 0; j < addHouseArray.length; j++) {
            var index = j + 1;
            var house = addHouseArray[j];
            if (house.is_zx == 1) {
                houseAddHtml += '<tr style="color:red !important">';
            } else {
                houseAddHtml += '<tr>';
            }
            houseAddHtml += "<td>" + "<input type='checkbox' name='memberCheck2' value='" + j + "'>" + "</td>";
            houseAddHtml += "<td>" + index + "</td>";
            houseAddHtml += "<td>" + house.itemname + "</td>";
            if (house.is_zx == 1) {
                houseAddHtml += "<td>" + "是" + "</td>";
            } else {
                houseAddHtml += "<td>" + "否" + "</td>";
            }
            houseAddHtml += "<td>" + house.prj_dist_name + "</td>";
            houseAddHtml += "<td>" + house.room + "</td>";
            houseAddHtml += "<td>" + house.pic_area + "</td>";
            houseAddHtml += "<td>" + house.price_show + "</td>";
            var totalPrice = house.pic_hx_totalprice;

            houseAddHtml += "<td>" + house.downPayment + "</td>";
            houseAddHtml += "<td>" + house.monthPay + "</td>";
            houseAddHtml += "<td>" + totalPrice + "</td>";
            houseAddHtml += "<td>" + house.sale + "</td>";
            var id = "orderAddNo" + index;
            houseAddHtml += "<td>" + "<input style='width: 100px' type='number' name='orderNo' id ='" + id + "'" + ">" + "</td>";
            houseAddHtml += "</tr>";
        }
        $("#houseAddHtml").html(houseAddHtml);
        $('#myModal05').modal('hide');
        $('#myModal05').css('margin', "0 auto");
        $(".borNone").css("z-index","-999")
    };

    window.onload = function () {
        $('.modal').on('hide.bs.modal', function () {
            $("body").removeClass('modal-open');
            $("body").css('padding-right', '0px');
        })
    };
    var searchByName = function () {
        var houseName = $("#houseName").val();
        var isLoan = $("input[name='isLoan']:checked").val();
        var downPaymentRatio = $("#downPaymentRatio").val();
        if (typeof(houseName) == "undefined" || houseName == '' || houseName == null) {
            alert("请填写楼盘名");
            return;
        }
        var data = {
            customerName: houseName,
            isLoan: isLoan,
            downPaymentRatio: downPaymentRatio
        };
        data = JSON.stringify(data);
        $.ajax({
            url: '${ctx}/propertyreport/searchHouse/2',
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (data) {
                if (data.status == 0) {
                    houseNameArray = data.data;
                    var houseNameHtml = "";
                    for (var i = 0; i < data.data.length; i++) {
                        var house = data.data[i];
                        if (house.is_zx == 1) {
                            houseNameHtml += '<tr style="color:red !important">';
                        } else {
                            houseNameHtml += '<tr>';
                        }
                        houseNameHtml += "<td>" + "<input type='checkbox' name='memberCheck1' value='" + i + "'>" + "</td>";
                        houseNameHtml += "<td>" + house.itemname + "</td>";
                        if (house.is_zx == 1) {
                            houseNameHtml += "<td>" + "是" + "</td>";
                        } else {
                            houseNameHtml += "<td>" + "否" + "</td>";
                        }
                        houseNameHtml += "<td>" + house.prj_dist_name + "</td>";
                        houseNameHtml += "<td>" + house.room + "</td>";
                        houseNameHtml += "<td>" + house.pic_area + "</td>";
                        houseNameHtml += "<td>" + house.price_show + "</td>";
                        var totalPrice = house.pic_hx_totalprice;

                        houseNameHtml += "<td>" + house.downPayment + "</td>";
                        houseNameHtml += "<td>" + house.monthPay + "</td>";
                        houseNameHtml += "<td>" + totalPrice + "</td>";
                        houseNameHtml += "<td>" + house.sale + "</td>";
                        houseNameHtml += "</tr>";
                    }
                    $("#houseNameHtml").html(houseNameHtml);
                } else {
                    alert(data.errorMessage);
                }
            }
        });

    };

    //全选
    var checkNum = 0;
    var checkHouseNum = 0;
    var checkAddNum = 0;
    var num3 = 0;
    function checkAll(btn) {
        if (btn.checked) {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                checkNum++;
                document.getElementsByName('memberCheck')[i].checked = "checked";
            }
        } else {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                checkNum++;
                document.getElementsByName('memberCheck')[i].checked = "";
            }
        }
    }

    function checkAll1(btn) {
        if (btn.checked) {
            for (var i = 0; i < document.getElementsByName('memberCheck1').length; i++) {
                checkHouseNum++;
                document.getElementsByName('memberCheck1')[i].checked = "checked";
            }
        } else {
            for (var i = 0; i < document.getElementsByName('memberCheck1').length; i++) {
                checkHouseNum++;
                document.getElementsByName('memberCheck1')[i].checked = "";
            }
        }
    }

    function checkAll2(btn) {
        if (btn.checked) {
            for (var i = 0; i < document.getElementsByName('memberCheck2').length; i++) {
                checkAddNum++;
                document.getElementsByName('memberCheck2')[i].checked = "checked";
            }
        } else {
            for (var i = 0; i < document.getElementsByName('memberCheck2').length; i++) {
                checkAddNum++;
                document.getElementsByName('memberCheck2')[i].checked = "";
            }
        }
    }

    function checkAll3(btn) {
        if (btn.checked) {
            for (var i = 0; i < document.getElementsByName('memberCheck3').length; i++) {
                num3++;
                document.getElementsByName('memberCheck3')[i].checked = "checked";
            }
        } else {
            for (var i = 0; i < document.getElementsByName('memberCheck3').length; i++) {
                num3++;
                document.getElementsByName('memberCheck3')[i].checked = "";
            }
        }
    }

    function isPInt(str) {
        var g = /^[1-9]*[1-9][0-9]*$/;
        return g.test(str);
    }

</script>

</body>
</html>