<%@ page language="java" pageEncoding="UTF-8" %>
<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<html>
<head>
    <title>经管项目新增</title>
</head>
<body>
<!-- 流式布局，页面上部空出50px-->
<div class="row${fluid} house365Page">
    <!-- 页面内容置中，左右各留span1 -->
    <div id="message"></div>
    <house365:flushMessage/>
    <!-- 页头  begin -->
    <div class="row${fluid}">
        <div class="span12 house365Title">
            <div class="span6">
                <h1 class="pageTitle">经管项目新增</h1>
            </div>
            <div class="span6" align="right">
                <h3 class="sm_op">
                    <a class="btn" id="saveButton_i" href="#"><i class="" title="保存"></i>保存&nbsp;&nbsp;&nbsp;</a>
                </h3>
            </div>
        </div>
    </div>
    <!-- 页头  end -->
    <!-- 面包屑 begin -->
    <div class="row${fluid}">
        <div class="span12">
            <ul class="breadcrumb">
                <li><a href="${ctx}/project">项目管理</a> <span class="divider">/</span></li>
                <li class="active">经管项目新增</li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <div class="house365Border">
        <!-- 片段头 begin -->
        <div class="sectionTitle">
            <h5>基本信息</h5>
        </div>

        <!-- 水平表单 begin -->
        <form id="input_form" class="form-horizontal valid"
              action="${ctx}/project/jgAdd" method="post">
            <!-- 基本信息 begin -->
            <div class="row${fluid}">
                <div class="span6 control-group">
                    <label class="control-label">合同号
                        <span style="color: red;">*</span>：
                    </label>

                    <div class="controls">
                        <input type='hidden' id="information" name="information"
                               class="span6 required" requird>
                        <input type="text"
                               id="temp_information" name="temp_information"
                               class="span6 required" placeholder="请输入合同号" required/>
                        <input type='hidden' id="contractCode" name="entity.contractCode"
                               class="span6 required" required>
                        <input type='hidden' id="city" name="entity.city"
                               class="span6" requird>
                        <input type='hidden' id="cityName" name="entity.cityName"
                               class="span6" requird>
                    </div>
                </div>
                <div class="span6 control-group">
                    <label class="control-label">项目名称<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="text" id="projectName"
                               name="entity.projectName" class="required"
                               readonly="readonly"/>
                    </div>
                </div>
            </div>
            <div class="row${fluid}">
                <div class="span6 control-group">
                    <label class="control-label">项目状态<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="hidden" id="status"
                               name="entity.status" class="required"
                               readonly="readonly"/>
                        <input type="text" id="statusStr" readonly="readonly"/>

                    </div>
                </div>
                <div class="span6 control-group">
                    <label class="control-label">项目编号<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="text" id="projectCode"
                               name="entity.projectCode" class="required"
                               readonly="readonly"/>

                    </div>
                </div>
            </div>
            <div class="row${fluid}">
                <div class="span6 control-group">
                    <label class="control-label">关联楼盘ID<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="text" id="buildingId"
                               name="entity.buildingId" class="required"
                               readonly="readonly"/>

                    </div>
                </div>
                <div class="span6 control-group">
                    <label class="control-label">关联楼盘名称<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="text" id="buildingName"
                               name="entity.buildingName" class="required"
                               readonly="readonly"/>

                    </div>
                </div>
            </div>
            <div class="row${fluid}">
                <div class="span6 control-group">
                    <label class="control-label">项目经理<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="text" id="manager"
                               name="entity.manager" class="required"
                               readonly="readonly"/>

                    </div>
                </div>
                <div class="span6 control-group">
                    <label class="control-label">物业类型<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="text" id="type"
                               name="entity.type" class="required"
                               readonly="readonly"/>

                    </div>
                </div>
            </div>
            <div class="row${fluid}">
                <div class="span6 control-group">
                    <label class="control-label">开发企业<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="text" id="kfs"
                               name="entity.kfs" class="required"
                               readonly="readonly"/>

                    </div>
                </div>
                <div class="span6 control-group">
                    <label class="control-label">业务类型<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="text" id="business"
                               name="entity.business" class="required"
                               readonly="readonly"/>

                    </div>
                </div>
            </div>
            <div class="row${fluid}">
                <div class="span6 control-group">
                    <label class="control-label">项目地址<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="text" id="address"
                               name="entity.address" class="required"
                               readonly="readonly"/>

                    </div>
                </div>
                <div class="span6 control-group">
                    <label class="control-label">开盘时间<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <input type="text" id="startTime"
                               name="entity.startTimeStr" class="required"
                               readonly="readonly"/>
                        <!-- <input type="text" id="entity.startTimeStr" class="datetime-picker required"
                                name="entity.startTimeStr" readonly="readonly" />	 -->

                    </div>
                </div>
            </div>

            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <h5>其他信息</h5>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">房源状况:</label>
                            <div class="controls">
										<textarea class="span9" id="entity.source" name="entity.source" rows="6"
                                                  placeholder="房源状况">${entity.source}</textarea>
                                <span style="color: red"><form:errors path="projectVo.entity.source"/></span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">即时销售信息:</label>
                            <div class="controls">
										<textarea class="span9" id="entity.jitInfo" name="entity.jitInfo" rows="6"
                                                  placeholder="即时销售信息">${entity.jitInfo}</textarea>
                                <span style="color: red"><form:errors path="projectVo.entity.jitInfo"/></span>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">佣金标准:</label>
                            <div class="controls">
										<textarea class="span9" id="entity.hireMoney" name="entity.hireMoney" rows="6"
                                                  placeholder="佣金标准">${entity.hireMoney}</textarea>
                                <span style="color: red"><form:errors path="projectVo.entity.hireMoney"/></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>


<!-- 水平表单 end -->
</div>
<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script src="${static_common}/script/select2-3.5.2/select2.js"></script>
<script type="text/javascript">
    $(document).ready(function () {

        $("#temp_information").hide();
        $("#temp_information").on("click", function () {
            $(this).hide();
            $("#s2id_information").show();
            $("#s2id_information").click();
        });
        $("#information").select2({
            placeholder: "请输入合同号",
            // 输入几个字符开始联想
            minimumInputLength: 1,
            // 最大返回记录数
            minimumResultsForSearch: 10,
            maximumSelectionLength: 1,
            minimumSelectionLength: 1,
            containerCssClass: "required chosen",
            formatResultCssClass: function () {
                return "required";
            },
            query: function (query) {
                $.ajax({
                    timeout: 1000,
                    url: "${ctx}/remote/projectList",
                    data: {
                        limit: 10,
                        contractCode: query.term,
                    },
                    type: "GET",
                    dataType: "json",
                    success: function (data, status) {
                        var pageData = {
                            results: []
                        };
                        if (data.status) {
                            $.each(data.data, function (i, item) {
                                pageData.results.push({
                                    id: item.projectCode + ";" + item.contractCode + ";" + item.projectName + ";" + item.buildingId + ";" + item.buildingName + ";"
                                    + item.status + ";" + item.manager + ";" + item.type + ";" + item.kfs + ";" + item.city + ";" + item.cityName +
                                    ";" + item.address + ";" + item.startTime + ";" + item.business,
                                    text: item.contractCode + ""
                                });
                            });

                        }
                        query.callback(pageData);

                    },
                    error: function () {
                        var pageData = {
                            results: []
                        };
                        query.callback(pageData);
                    }
                });
            }
        });
        $("#information").on("change", function (e) {
            $("#temp_information").val(e.added.text);
            var info = $('#information').val();
            var splitInfo = info.split(';');
            $("#projectCode").val(splitInfo[0]);
            $("#contractCode").val(splitInfo[1]);
            $("#projectName").val(splitInfo[2]);
            $("#buildingId").val(splitInfo[3]);
            $("#buildingName").val(splitInfo[4]);
            $("#status").val(splitInfo[5]);
            if ($("#status").val() == '1') {
                $("#statusStr").val("默认");
            } else if ($("#status").val() == '2') {
                $("#statusStr").val("执行中");
            } else if ($("#status").val() == '3') {
                $("#statusStr").val("办结");
            } else if ($("#status").val() == '4') {
                $("#statusStr").val("合同周期结束");
            } else if ($("#status").val() == '5') {
                $("#statusStr").val("终止");
            } else if ($("#status").val() == '6') {
                $("#statusStr").val("立项审核中");
            } else if ($("#status").val() == '7') {
                $("#statusStr").val("删除");
            } else {
                $("#statusStr").val("未知");
            }

            $("#manager").val(splitInfo[6]);
            $("#type").val(splitInfo[7]);
            $("#kfs").val(splitInfo[8]);
            $("#city").val(splitInfo[9]);
            $("#cityName").val(splitInfo[10]);
            $("#address").val(splitInfo[11]);
            $("#startTime").val(splitInfo[12]);
            $("#business").val(splitInfo[13]);

        });

        $("#saveButton_i").click(function () {
            $('#input_form').submit();
        });

    })
</script>
</body>
</html>