<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>标签列表</title>
</head>
<body>
<style>
    .tag-item {
        color: white;
    }
</style>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>标签列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline" action="" method="get">
                <label>
                    标签：
                    <input type="text" id="search_LIKE_labelName" name="search_LIKE_labelName" value="${labelName}"/>
                    <span type="button" class="btn btn-default"
                          onclick="$('#filterForm').submit();">搜索
                    </span>&nbsp;&nbsp;&nbsp;&nbsp;
                    <div class="buttons pull-right" style="margin-left:15px;">
                        <a href="${ctx}/labelmanager/?action=create" class="btn blue pull-right" title="新增"><i
                                class="icon-plus"></i></a>
                    </div>
                </label>

            </form>
        </div>
    </div>
    <c:choose>
        <c:when test="${showcontent=='1'}">
            <table class="table table-striped table-advance table-hover">
                <thead>
                <tr>
                    <th width="100">序号</th>
                    <th width="100">标签</th>
                    <th width="100">客户数量</th>
                    <th width="100">创建人</th>
                    <th width="100">更新时间</th>
                    <th width="150">操作</th>
                </tr>
                </thead>
                <c:forEach items="${labels}" var="label">
                    <tr>
                        <td nowrap="nowrap">
                            <c:out value="${label.labelId}"/>
                        </td>
                        <td nowrap="nowrap">
                            <c:if test="${1 eq label.colorId}">
                                <span class="tag-item gray" style="background:#999" data-index="1"><c:out
                                        value="${label.labelName}"/></span>
                            </c:if>
                            <c:if test="${2 eq label.colorId}">
                                <span class="tag-item red" style="background:#d9534f" data-index="2"><c:out
                                        value="${label.labelName}"/></span>
                            </c:if>
                            <c:if test="${3 eq label.colorId}">
                                <span class="tag-item orange" style="background:#f0ad4e" data-index="3"><c:out
                                        value="${label.labelName}"/></span>
                            </c:if>
                            <c:if test="${4 eq label.colorId}">
                                <span class="tag-item green" style="background:#5cb85c" data-index="4"><c:out
                                        value="${label.labelName}"/></span>
                            </c:if>
                            <c:if test="${5 eq label.colorId}">
                                <span class="tag-item blue" style="background:#5bc0de" data-index="5"><c:out
                                        value="${label.labelName}"/></span>
                            </c:if>
                            <c:if test="${6 eq label.colorId}">
                                <span class="tag-item darkblue" style="background:#0275d8" data-index="6"><c:out
                                        value="${label.labelName}"/></span>
                            </c:if>
                            <c:if test="${7 eq label.colorId}">
                                <span class="tag-item zi" style="background:#663399" data-index="7"><c:out
                                        value="${label.labelName}"/></span>
                            </c:if>
                        </td>
                        <td nowrap="nowrap">
                            <c:if test="${null eq label.num}">
                                <c:out value="0"/>
                            </c:if>
                            <c:if test="${null ne label.colorId}">
                                <c:out value="${label.num}"/>
                            </c:if>
                        </td>
                        <td nowrap="nowrap">
                            <c:out value="${label.createName}"/>
                        </td>
                        <td nowrap="nowrap">
                            <f:formatDate value='${label.updateTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                        </td>
                        <td nowrap="nowrap">
                            <a href="${ctx}/labelmanager/${label.labelId}/${label.colorId}/${label.labelName}?action=edit"
                               target="_blank">编辑</a>
                            <button type="button" class="btn btn-warning" onclick="delLabel(${label.labelId})">删除
                            </button>
                        </td>
                    </tr>
                </c:forEach>
            </table>
            <div class="row${fluid}">
                <house365:newPagination page="${page}"/>
            </div>
        </c:when>

        <c:otherwise>
            <span class="inline">暂无标签</span>
        </c:otherwise>
    </c:choose>


</div>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>
<script type="text/javascript">

    var delLabel = function (id) {

        House365Util.createModal("删除客户", "确定要删除该标签？", function () {
            $.ajax({
                url: '${ctx}/labelmanager/delLabel?id=' + id,
                type: "DELETE",
                success: function (data) {
                    if (data == "success") {
                        window.location.reload();
                    } else {
                        alert("删除失败");
                        return false;
                    }
                }
            });
        });

    };


    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    })
</script>
</body>
</html>
