<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<!DOCTYPE html>

<!--[if lt IE 7 ]><html class="ie ie6" lang="en"> <![endif]-->
<!--[if IE 7 ]><html class="ie ie7" lang="en"> <![endif]-->
<!--[if IE 8 ]><html class="ie ie8" lang="en"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!-->
<html lang="en" xmlns="http://www.w3.org/1999/html"> <!--<![endif]-->

<head>
    <title>${title}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7">

    <meta http-equiv="Cache-Control" content="no-store"/>
    <meta http-equiv="Pragma" content="no-cache"/>
    <meta http-equiv="Expires" content="0"/>

    <title>${title}</title>
    <%--<link rel="icon" href="${ctx}/favicon.ico">--%>
    <%--<link rel="shortcut icon" href="${ctx}/favicon.ico">--%>
    <%@include file="/WEB-INF/common/layouts/import-css.jsp" %>
</head>
<body>

<div id="treeContainer" class="ui-layout-west"></div>

<%@include file="/WEB-INF/common/layouts/import-js.jsp" %>

<shiro:hasPermission name="DEPARTMENT_EDIT">
    <input type="radio" hidden="hidden" id="treeEditFlag" value="" checked="checked"/>
</shiro:hasPermission>
</body>

<script type="text/javascript">
    var async = ${not empty param.async and param.async eq true};
    $(function () {
        var zNodes = [
            <c:forEach items="${trees}" var="m">
            {
                "id": "${m.id}",
                "pId": "${m.parentId}",
                "name": "${m.name}",
                "open": true,
                "root": ${m.root}
            },
            </c:forEach>
        ];

        $.zTree.initMovableTree({
            zNodes: zNodes,
            urlPrefix: "${ctx}/department",
            async: async,
            onlyDisplayShow: ${empty param['show'] ? '0' : param['show']},
            autocomplete: {
                enable: false
            },
            editable: true,//$("#treeEditFlag").is(":checked"),
            containerId: 'treeContainer',
            maxLevel: 10,
            setting: {
                callback: {
                    onClick: function (event, treeId, treeNode, clickFlag) {
                        //effectDept = treeNode.id;
                        var url = '${ctx}/user/?search_EQ_deptId=' + treeNode.id;
                        // console.log(window.frames['listFrame']);
                        window.frames['listFrame'].location.href = url;
                    }/* ,
                     onRightClick: function onRightClick(event, treeId, treeNode) {
                     //alert(treeNode ? treeNode.tId + ", " + treeNode.name : "isRoot");
                     window.frames['listFrame'].location.href = "${ctx}/department/"+ treeNode.id+"?action=edit";
                     } */
                }
            }
        });

    });
</script>
