<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>客户活动来源列表</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>客户活动来源列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/customersource" method="get">
                <input type="text" name="search_LIKE_sourceName" value="${param['search_LIKE_sourceName']}"
                       class="m-wrap small span2" placeholder="名称">
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/customersource?action=create" class="btn blue pull-right" title="新增"><i
                            class="icon-plus"></i></a>
                </div>
                <div class="buttons pull-right">
                    <a href="javascript:void(0);" onclick="deleteById('')" class="btn blue pull-right" title="删除"><i
                            class="icon-minus"></i></a>
                </div>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center"><input id="memberCheckAll" type="checkbox"
                                                            onclick="checkAll(this)"/></th>
            <th width="100">id</th>
            <th width="100">名称</th>
            <th width="100">排序</th>
            <th width="100">创建人</th>
            <th width="100">创建时间</th>
            <th width="100">来源</th>
            <th width="100">类别</th>
            <th width="100">城市</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${customerSources}" var="customerSource">
            <tr>
                <td nowrap="nowrap" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${customerSource.id}" onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <a href="${ctx}/customersource/${customerSource.id}"> <c:if
                            test="${null ne customerSource.id && '' ne customerSource.id}">
                        <c:out value="${customerSource.id}"/>
                    </c:if>
                        <c:if test="${null eq customerSource.id || '' eq customerSource.id}">
                            &nbsp;
                        </c:if>
                    </a>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customerSource.sourceName && '' ne customerSource.sourceName}">
                        <c:out value="${customerSource.sourceName}"/>
                    </c:if>
                    <c:if test="${null eq customerSource.sourceName || '' eq customerSource.sourceName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customerSource.sort && '' ne customerSource.sort}">
                        <c:out value="${customerSource.sort}"/>
                    </c:if>
                    <c:if test="${null eq customerSource.sort || '' eq customerSource.sort}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customerSource.creater && '' ne customerSource.creater}">
                        <c:out value="${customerSource.creater}"/>
                    </c:if>
                    <c:if test="${null eq customerSource.creater || '' eq customerSource.creater}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customerSource.createTime && '' ne customerSource.createTime}">
                        <f:formatDate value='${customerSource.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq customerSource.createTime || '' eq customerSource.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customerSource.source && '' ne customerSource.source}">
                        <c:if test="${'SYSTEM' eq customerSource.source}">
                            系统录入
                        </c:if>
                        <c:if test="${'SYSTEM' ne customerSource.source}">
                            ${customerSource.source}
                        </c:if>
                    </c:if>
                    <c:if test="${null eq customerSource.source || '' eq customerSource.source}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${0 == customerSource.type}">
                        私客管理
                    </c:if>
                    <c:if test="${1 == customerSource.type}">
                        平台客户管理
                    </c:if>
                    <c:if test="${2 == customerSource.type}">
                        外部客户管理
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customerSource.city && '' ne customerSource.city}">
                        <c:out value="${customerSource.city}"/>
                    </c:if>
                    <c:if test="${null eq customerSource.city || '' eq customerSource.city}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <i class="icon-edit pointer icon-large"
                       onclick="window.location='${ctx}/customersource/${customerSource.id}?action=edit'"></i>
                    &nbsp;&nbsp; <i
                        title="删除"
                        class="icon-minus pointer icon-large"
                        onclick="deleteById('${customerSource.id}')"> </i>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除", "请至少选择一条纪录!", function () {
            });
        }
        else {
            House365Util.createModal("删除", "确定要删除该纪录？", function () {
                $.ajax({
                    url: '${ctx}/customersource/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

</script>
</body>
</html>
