<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>成交客户</title>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>

<style>
    .dataTables_info {
        position: absolute;
        right: 753px;
        top: 77px;
    }

    .inputSearch {
        margin-right: 20px;
    }

    .table-complex {
        background-color: #f9f9f9;
    }

    .table-star {
        background-color: #FFEB3B;
    }

    .lastChoseCustomer {
        background-color: #91bfbf;
    }

    .numbers {
        font-size: 14px;
        color: #AAB5BC;
        font-weight: 600;
        text-transform: uppercase;
    }

    .font-blue-sharp {
        color: #5C9BD1 !important;
    }

    .dashboard-stat2 {
        -webkit-border-radius: 2px;
        -moz-border-radius: 2px;
        -ms-border-radius: 2px;
        -o-border-radius: 2px;
        border-radius: 2px;
        background: #eff3f8;
        padding: 15px 15px 30px;
        margin-bottom: 20px;
    }

    .dashboard-stat2 .display .number {
        float: left;
        display: inline-block;
    }

    .dashboard-stat2 .display .number small {
        font-size: 14px;
        color: #AAB5BC;
        font-weight: 600;
        text-transform: uppercase;
    }

    .dashboard-stat2 .display .number h5 {
        margin: 0 0 2px;
        padding: 0;
        font-size: 20px;
        font-weight: 400;
    }

    .dashboard-stat2, .dashboard-stat2 .display {
        margin-bottom: 20px;
    }

    .dashboard-stat2 .display .icon {
        display: inline-block;
        float: right;
        padding: 0;
    }

    .dashboard-stat2 .display .icon > i {
        color: #cbd4e0;
        font-size: 26px;
    }

    input[type='text'] {
        margin-right: 15px;
    }

    .num3 {
        background: green;
        color: #fff;
        padding: 1px 6px;
        border-radius: 10px;
    }

    .tag-item {
        color: white;
    }

    .temp {
        border: 1px solid #cccccc;
        width: 430px !important;
        height: 160px !important;
        position: relative;
        top: -26px;
        left: 81px;
    }

    .chosen-container {
        margin-left: 7px !important;
        width: 96px !important;
    }

    .shouc {
        position: absolute;
        right: 12px;
    }

    .table td.mangerItem.mangerlist {
        overflow: hidden;
        padding: 0;
        width: 33%;
    }

    .offset1 {
        display: none;
    }

    .mangerId_num.mine {
        width: auto !important;
        min-width: 60px;
    }

    .mangerId_name {
        margin-left: 0px;
    }

    .mangerId_name, .mangerId_content, .mangerId_state {
        width: 22.5%;
        text-align: center;
    }

    .mangerId_content {
        width: 30%;
    }

    .mangerlist__date {
        width: 30%;
    }

    .mangerlist__item {

    }

    .mangerlist__txt {
        width: 28%;
        margin-left: 120px;
    }

    .table td.mangerItem.mangerOperate {
        width: 82%;
        left: 53px;
    }

    .mangerOperate__time {
        top: 38px;
    }

    .mangerId_phone {
        text-align: left;
    }
</style>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                成交客户列表
            </li>

        </ul>
    </div>
</div>

<form id="filterForm" class="form-inline filterForm" action="${ctx}/customermanagement/successList" method="get"
      style="margin: 11px 0 6px 0;">
    <div class="row-fluid"
         style="border-style: solid;border-width: thin;border-color: #d5d5d5;padding: 20px;margin-bottom: 20px;line-height: 43px;">
        <div class="span12">
            添加时间： <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text"
                         name="search_createTimeStart"
                         id="search_createTimeStart" value="${param['search_createTimeStart']}"
                         class="m-wrap small span2">
            至
            <input style="width: 7rem;margin-left: 15px;border: 1px solid #d5d5d5;" type="text"
                   name="search_createTimeEnd"
                   id="search_createTimeEnd" value="${param['search_createTimeEnd']}"
                   class="m-wrap small span2">
            <%--回访时间： <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text"--%>
                         <%--name="search_lastCallTimeStart"--%>
                         <%--id="search_lastCallTimeStart" value="${param['search_lastCallTimeStart']}"--%>
                         <%--class="m-wrap small span2">--%>
            <%--至--%>
            <%--<input style="width: 7rem;margin-left: 15px;border: 1px solid #d5d5d5;" type="text"--%>
                   <%--name="search_lastCallTimeEnd"--%>
                   <%--id="search_lastCallTimeEnd" value="${param['search_lastCallTimeEnd']}"--%>
                   <%--class="m-wrap small span2">--%>

            &nbsp;&nbsp;

            <span id="createTimeRecentSeven"
                  style="cursor: pointer;<c:if test="${'2' eq timePeriod}">color: #30A3DE;</c:if>"
                  onclick="createTimeClick('2')">近7天</span>&nbsp;&nbsp;
            <span id="createTimeRecentThirty"
                  style="cursor: pointer;<c:if test="${'1' eq timePeriod}">color: #30A3DE;</c:if>"
                  onclick="createTimeClick('1')">30天</span>&nbsp;&nbsp;
            <span id="createTimeAll"
                  style="cursor: pointer;<c:if test="${'0' eq timePeriod}">color: #30A3DE;</c:if>"
                  onclick="createTimeClick('0')">全部</span>&nbsp;&nbsp;
            &nbsp;&nbsp;

            <br/>
            客户姓名：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_name"
                        name="search_name" value="${param['search_name']}"
                        class="m-wrap small" placeholder="客户姓名">&nbsp;&nbsp;&nbsp;&nbsp;
            客户手机：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_phone"
                        name="search_phone" value="${param['search_phone']}"
                        class="m-wrap small" placeholder="客户手机">&nbsp;&nbsp;&nbsp;&nbsp;
            置业顾问：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_managerName"
                        name="search_managerName" value="${param['search_managerName']}"
                        class="m-wrap small" placeholder="置业顾问">&nbsp;&nbsp;&nbsp;&nbsp;
            成交楼盘：<input type="text" id="search_projectName" style="border: 1px solid #d5d5d5;"
                        name="search_projectName" value="${param['search_projectName']}"
                        class="m-wrap small" placeholder="成交楼盘">


            <select style="width: 120px" name="search_orderByTime" id="search_orderByTime"
                    onchange="$('#filterForm').submit();">
                <option value="1"
                        <c:if test="${'1' eq param['search_orderByTime']}">selected="selected"</c:if>>
                    添加时间降序
                </option>
                <option value="2"
                        <c:if test="${'2' eq param['search_orderByTime']}">selected="selected"</c:if>>
                    添加时间升序
                </option>
                <%--<option value="3"--%>
                        <%--<c:if test="${'3' eq param['search_orderByTime']}">selected="selected"</c:if>>--%>
                    <%--回访时间降序--%>
                <%--</option>--%>
                <%--<option value="4"--%>
                        <%--<c:if test="${'4' eq param['search_orderByTime']}">selected="selected"</c:if>>--%>
                    <%--回访时间升序--%>
                <%--</option>--%>
                <option value="5"
                        <c:if test="${'5' eq param['search_orderByTime']}">selected="selected"</c:if>>
                    派工时间降序
                </option>
                <option value="6"
                        <c:if test="${'6' eq param['search_orderByTime']}">selected="selected"</c:if>>
                    派工时间升序
                </option>
            </select>
            <div style="float: right">
                <button type="button" class="btn btn-default"
                        onclick="$('#filterForm').submit();">搜索
                </button>&nbsp;&nbsp;&nbsp;&nbsp;
                <button type="button" class="btn btn-default"
                        onclick="resetForm()">重置
                </button>
                <input type="hidden" id="timePeriod" name="timePeriod" value="${timePeriod}"/>
            </div>
        </div>
    </div>

</form>


<table class="table table-advance mine">
    <tbody>
    <c:forEach items="${dataList}" var="customer" varStatus="vs">
        <tr id="customerId_${customer.id}" class="header expand">
            <td class="mangerId mangerItem mine" style="width: 32%">
                <div class="mangerItem__border"></div>
                <input type="checkbox" name="memberCheck" value="${customer.id}">
                <span class="mangerId_num mine">${customer.id}</span>
                <span class="mangerId_name">
                       <c:if test="${null ne customer.name && '' ne customer.name}">
                           <c:choose>
                               <c:when test="${fn:length(customer.name) > 3}">
                                   <c:out value="${fn:substring(customer.name, 0, 3)}..."/>
                               </c:when>
                               <c:otherwise>
                                   <c:out value="${customer.name}"/>
                               </c:otherwise>
                           </c:choose>
                       </c:if>
                       <c:if test="${null eq customer.name || '' eq customer.name}">
                           &nbsp;
                       </c:if>
                </span>
                <div class="mangerId_content">
                    <div class="mangerId_phone">
                        <c:if test="${null ne customer.phone && '' ne customer.phone}">
                            <a href="javascript:void(0)" onclick="getCRM(${customer.id})"><c:out
                                    value="${customer.phone}"/></a>
                        </c:if>
                        <c:if test="${null eq customer.phone || '' eq customer.phone}">
                            &nbsp;
                        </c:if>
                    </div>

                    <div class="mangerId_person">
                        <div class="mangerId_avar">
                            <c:if test="${null ne customer.managerName && '' ne customer.managerName}">
                                <c:out value="${customer.managerName}"/>
                            </c:if>
                            <c:if test="${null eq customer.managerName || '' eq customer.managerName}">
                                &nbsp;
                            </c:if>
                        </div>
                        <div class="mangerId_up">
                        <c:choose>
                            <c:when test="${customer.buyIntention eq '1'}">
                                A
                            </c:when>
                            <c:when test="${customer.buyIntention eq '2'}">
                                B
                            </c:when>
                            <c:when test="${customer.buyIntention eq '3'}">
                                C
                            </c:when>
                            <c:when test="${customer.buyIntention eq '4'}">
                                D
                            </c:when>
                            <c:when test="${customer.buyIntention eq '5'}">
                                E
                            </c:when>
                            <c:otherwise>
                                待定
                            </c:otherwise>
                        </c:choose>
                    </div>
                    </div>
                </div>
                <div class="mangerId_state" style="width: 17.5%">
                    <c:if test="${not empty customer.status}">
                        <c:choose>
                            <c:when test="${customer.status eq '4'}">
                                认购
                            </c:when>
                            <c:when test="${customer.status eq '5'}">
                                签约
                            </c:when>
                            <c:otherwise>
                                待定
                            </c:otherwise>
                        </c:choose>
                    </c:if>
                    <c:if test="${empty customer.traceStatus}">
                    </c:if>
                </div>
            </td>
            <td class="mangerlist mangerItem" style="width: 42%">
                <c:if test="${0 ne fn:length(customer.callbackLogEntities)}">
                    <div class="mangerlist__txt" style="text-indent:0">
                        <div class="mangerlist__item">
                            <c:forEach items="${customer.callbackLogEntities}" var="callbackLog"
                                       varStatus="index">
                                <p>
                                    <c:if test="${empty callbackLog.content && index.count<=3}">
                                        <c:if test="${empty callbackLog.callRecordId}">
                                            [电话已拨，但未接通或被挂断]
                                        </c:if>
                                        <c:if test="${not empty callbackLog.callRecordId && index.count<=3}">
                                            [语音记录]
                                        </c:if>
                                    </c:if>
                                    <c:if test="${not empty callbackLog.content && index.count<=3}">
                                        <c:choose>
                                            <c:when test="${fn:length(callbackLog.content) > 10}">
                                                <c:out value="${fn:substring(callbackLog.content, 0, 10)}..."/>
                                            </c:when>
                                            <c:otherwise>
                                                <c:out value="${callbackLog.content}"/>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:if>
                                </p>
                            </c:forEach>
                        </div>
                    </div>
                    <div class="mangerlist__date">
                        <div class="mangerlist__dateC">
                            <c:forEach items="${customer.callbackLogEntities}" var="callbackLog"
                                       varStatus="index">
                                <p><c:if test="${index.count<=3}">
                                    <f:formatDate value='${callbackLog.createTime}' pattern='MM-dd HH:mm'/>
                                </c:if>
                                </p>
                            </c:forEach>
                        </div>
                    </div>
                    <div class="mangerlist__record" onclick="showCustomerCallbackLogs('${customer.id}', '${customer.managerId}')">
                        查看回访记录
                    </div>
                </c:if>
                <c:if test="${0 eq fn:length(customer.callbackLogEntities)}">
                    <div class="mangerlist__txt">
                        <div class="mangerlist__item">
                            暂无回访记录！
                        </div>
                    </div>
                    <div class="mangerlist__date">
                        <div class="mangerlist__dateC">
                        </div>
                    </div>
                </c:if>
                <div class="mangerItem__border"></div>
            </td>

            <td class="mangerItem mangerOperate" style="display: table;padding: 0;overflow:visible;">

                <div class="mangerOperate__time" style="margin-top:-40px;width:150px;margin-right: 60px;">
                    <c:if test="${null ne customer.bindTime && '' ne customer.bindTime}">
                        派工:<f:formatDate value='${customer.bindTime}'
                                         pattern='MM-dd HH:mm'/>
                    </c:if>
                    <c:if test="${null eq customer.bindTime || '' eq customer.bindTime}">
                        &nbsp;
                    </c:if>
                </div>
                <div class="mangerOperate__time" style="right:0px;margin-top:-40px;">
                    <c:if test="${null ne customer.createTime && '' ne customer.createTime}">
                        <f:formatDate value='${customer.createTime}'
                                      pattern='MM-dd HH:mm'/>
                    </c:if>
                    <c:if test="${null eq customer.createTime || '' eq customer.createTime}">
                        &nbsp;
                    </c:if>
                </div>
                <div style="display: table-cell;vertical-align: middle">
                    <c:if test="${customer.hasCustomerProjects}">
                        <div class="mangerOperate__record"
                             onclick="showCustomerProjects('${customer.id}','${customer.managerId}')"
                             style="position: relative;">
                            约看记录
                            <c:if test="${customer.hasNewCustomerProjects}">
                                <div style="position: absolute; width: 8px;height: 8px;background-color: red;border-radius: 50%;top: 5px;right: -7px;"></div>
                            </c:if>
                        </div>
                    </c:if>
                    <c:if test="${!customer.hasCustomerProjects}">
                        <div class="mangerOperate__record none"
                             style="position: relative;cursor: default;color:grey;">
                            约看记录
                        </div>
                    </c:if>
                    <div class="mangerOperate__detail" onclick="customerInfo(${customer.id},${customer.managerId})">
                        查看详情
                    </div>
                </div>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="row-fluid" style="position: relative">
    <house365:newPagination page="${page}"/>
</div>

<script type="text/html" id="customerCallbackLogsTemplate">
    <div class="returnWinList">
        {{if callbackLogs.length !=0}}
        {{each callbackLogs as log index}}
        <div class="returnWinItem">
            <div class="returnWinItem__txt">
                {{if log.content != "" && log.content != null}}
                {{log.content}}
                {{/if}}
                {{if log.callRecordId != "" && log.callRecordId != null}}
                <audio controls>
                    <source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path={{log.callRecordName}}">
                    Your browser does not support this audio format.
                </audio>
                {{/if}}
                {{if (log.content == "" || log.content == null)}}
                {{if (log.callRecordId == "" || log.callRecordId == null)}}
                [电话已拨，但未接通或被挂断]
                {{/if}}
                {{if (log.callRecordId != "" && log.callRecordId != null)}}
                [语音记录]
                {{/if}}
                {{/if}}
            </div>
            <div class="returnWinItem__name" style="width:222px;top:35px;margin-left:-60px;">{{log.managerName}}</div>
            <div class="returnWinItem__date" style="width:222px;top:35px;margin-left:-60px;">{{log.createTime |
                dateFormat:'yyyy-MM-dd hh:mm:ss'}}
            </div>
            {{/each}}
            {{else}}
            暂无回访记录
            {{/if}}
        </div>
    </div>
</script>

<script type="text/html" id="customerProjectsTemplate">
    <div class="returnWinList list2">
        <div class="returnWinItem">
            <div class="reportWinItem bold date" style="text-indent: 27px;">约看楼盘</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">案场报备</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">客户状态</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">贷款状态</div>
            <div class="reportWinItem bold" style="width:150px">约看时间</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">操作</div>
        </div>
        {{if customerProjects.length !=0}}
        {{each customerProjects as cp index}}
        <div class="returnWinItem">
            <div class="reportWinItem date" style="text-indent: 27px;">
                <a href="{{ctx}}/project/{{cp.projectId}}" target="_blank">{{cp.projectName}}</a>
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                {{if cp.recordedStatus == '1'}}
                <span>案场已报备</span>
                {{else if cp.recordedStatus == '0'}}
                <span>案场未报备</span>
                {{else}}
                <span>无</span>
                {{/if}}
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                {{if cp.status == '1'}}
                <span>约看</span>
                {{else if cp.status == '2'}}
                <span>到访</span>
                {{else if cp.status == '3'}}
                <span>认筹</span>
                {{else if cp.status == '4'}}
                <span>认购</span>
                {{else if cp.status == '5'}}
                <span>签约</span>
                {{else if cp.status == '6'}}
                <span>退房</span>
                {{else}}
                <span>无</span>
                {{/if}}
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                {{if cp.loanStatus == '0'}}
                <span>未办理</span>
                {{else if cp.loanStatus == '1'}}
                <span>申请中</span>
                {{else if cp.loanStatus == '2'}}
                <span>已下款</span>
                {{else if cp.loanStatus == '3'}}
                <span>被拒绝</span>
                {{else if cp.loanStatus == '4'}}
                <span>全款支付</span>
                {{else}}
                <span>无</span>
                {{/if}}
            </div>
            <div class="reportWinItem" style="width:150px">
                <span>{{cp.createTime | dateFormat:'yyyy.MM.dd hh:mm:ss'}}</span>
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                <span><a href="{{ctx}}/customer/updateProjectInfo/{{cp.id}}" target="_blank">详情</a></span>
                <span color="red">{{cp.remark}}</span>
            </div>
        </div>
        {{/each}}
        {{else}}
        暂无约看记录
        {{/if}}
    </div>
</script>

<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/customize/js/template.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/customize/js/utils.js"></script>
<script type="text/javascript" src="${ctx}/resources/script/counterup/jquery.waypoints.min.js"></script>
<script type="text/javascript" src="${ctx}/resources/script/counterup/jquery.counterup.min.js"></script>

<script language="javascript" type="text/javascript">
    Date.prototype.pattern = function (fmt) {
        var o = {
            "M+": this.getMonth() + 1, //月份
            "d+": this.getDate(), //日
            "h+": this.getHours() % 12 == 0 ? 12 : this.getHours() % 12, //小时
            "H+": this.getHours(), //小时
            "m+": this.getMinutes(), //分
            "s+": this.getSeconds(), //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds() //毫秒
        };
        var week = {
            "0": "/u65e5",
            "1": "/u4e00",
            "2": "/u4e8c",
            "3": "/u4e09",
            "4": "/u56db",
            "5": "/u4e94",
            "6": "/u516d"
        };
        if (/(y+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        }
        if (/(E+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, ((RegExp.$1.length > 1) ? (RegExp.$1.length > 2 ? "/u661f/u671f" : "/u5468") : "") + week[this.getDay() + ""]);
        }
        for (var k in o) {
            if (new RegExp("(" + k + ")").test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            }
        }
        return fmt;
    }
</script>
<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
<script type="text/javascript">

    var enterFlag = 0;
    $(document).keydown(function (event) {
        var style = document.getElementById("modal_dialog").style.display;
        if (style == 'block') {
            enterFlag = 1;
        } else {
            enterFlag = 0;
        }
        if (enterFlag == 0 && event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    var lastChoseCustomerId = getCookie("lastChoseCustomerId");

    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    });

    $(function () {
        $('.counter').counterUp({
            delay: 100,
            time: 2000
        });
        $("#customerId_" + lastChoseCustomerId).addClass("lastChoseCustomer");

        // 初始化添加时间
        if ($('#timePeriod').val() == '0') {
            createTimeClick('0');
        }

        // 添加时间
        var createTimeStart = $("#search_createTimeStart");
        var createTimeEnd = $("#search_createTimeEnd");
        createTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: createTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
            $("#createTimeRecentSeven").css("color", "#000000");
            $("#createTimeRecentThirty").css("color", "#000000");
            $("#createTimeAll").css("color", "#000000");
            $("#timePeriod").val('3');
        });
        createTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: createTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: createTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_createTimeEnd'
                    })
                }
            });
            $("#createTimeRecentSeven").css("color", "#000000");
            $("#createTimeRecentThirty").css("color", "#000000");
            $("#createTimeAll").css("color", "#000000");
            $("#timePeriod").val('3');
        });

        // 回访时间
        var lastCallTimeStart = $("#search_lastCallTimeStart");
        var lastCallTimeEnd = $("#search_lastCallTimeEnd");
        lastCallTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: lastCallTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
        });
        lastCallTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: lastCallTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: lastCallTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_lastCallTimeEnd'
                    })
                }
            });
        });

        $('.baobei').each(function () { // Notice the .each() loop, discussed below
            $(this).qtip({
                content: {
                    text: $(this).next('div') // Use the "div" element next to this for the content
                },
                position: {
                    at: 'bottom center', // at the bottom right of...
                    target: $(this) // my target
                }
            });
        });

        $('.header').each(function () {
            $(this).nextUntil('tr.header').hide();
        });

        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });

    });

    function resetForm() {
        $("#createTimeRecentSeven").css("color", "#000000");
        $("#createTimeRecentThirty").css("color", "#000000");
        $("#createTimeAll").css("color", "#30A3DE");

        // 重置form
        $("#filterForm")[0].reset();

        $("#search_name").val('');
        $("#search_phone").val('');

        $("#search_managerName").val('');
        $("#search_createTimeStart").val('');
        $("#search_createTimeEnd").val('');
        $("#search_lastCallTimeStart").val('');
        $("#search_lastCallTimeEnd").val('');

        $("#search_projectName").val('');

        // 重置添加时间 近7天 开始时间结束时间
        createTimeClick('0');
    }

    function sortCreateTime() {
        var mode = $("#sort_createTime").val();
        if (mode == 'desc') {
            mode = 'asc';
        } else if (mode == 'asc') {
            mode = 'desc';
        } else if (mode == '' || mode == undefined) {
            mode = 'desc';
        }
        $("#sort_createTime").val(mode);

        $("#filterForm").submit();
    }

    function showCustomerCallbackLogs(customerId,managerId) {
        setCookie("lastChoseCustomerId", customerId);
        $.ajax({
            url: '${ctx}/customermanagement/getCustomerCallbackLogs',
            data: {
                "customerId": customerId,
                "managerId": managerId
            },
            type: "GET",
            success: function (data) {
                var callContentHtml = template('customerCallbackLogsTemplate', {
                    ctx: "${ctx}",
                    callbackLogs: data
                });
                House365Util.createModal("回访记录", callContentHtml, function () {
                });
                $(".modal").css("width", "900px");
            }
        });
    }

    function showCustomerProjects(_customerId, managerId) {
        setCookie("lastChoseCustomerId", _customerId);
        $.ajax({
            url: '${ctx}/customermanagement/getCustomerProjects',
            data: {
                "customerId": _customerId,
                "managerId": managerId
            },
            type: "GET",
            success: function (data) {

                var callContentHtml = template('customerProjectsTemplate', {
                    ctx: "${ctx}",
                    customerProjects: data
                });
                House365Util.createModal("约看记录", callContentHtml, function () {
                });
                $(".modal").css("width", "900px");
            }
        });
    }

    function createTimeClick(createTimeType) {
        var timeStart, timeEnd;
        var myDate = new Date();
        $("#timePeriod").val(createTimeType);

        switch (createTimeType) {
            case "2":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 7 + 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                $("#createTimeRecentSeven").css("color", "#30A3DE");
                $("#createTimeRecentThirty").css("color", "#000000");
                $("#createTimeAll").css("color", "#000000");
                break;
            case "1":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 30 + 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                $("#createTimeRecentSeven").css("color", "#000000");
                $("#createTimeRecentThirty").css("color", "#30A3DE");
                $("#createTimeAll").css("color", "#000000");
                break;
            case "0":
                timeEnd = "";
                timeStart = "";
                $("#createTimeRecentSeven").css("color", "#000000");
                $("#createTimeRecentThirty").css("color", "#000000");
                $("#createTimeAll").css("color", "#30A3DE");
                break;
            default:
                break;
        }
        $("#search_createTimeStart").val(timeStart);
        $("#search_createTimeEnd").val(timeEnd);
    }

    function customerInfo(id, managerId) {
        setCookie("lastChoseCustomerId", id);
        if (managerId != null && managerId != '') {
            window.open("/house365-hgs-web/customer/customerInfo?action=edit&customerId=" + id, "_blank");
        } else {
            window.open("/house365-hgs-web/customer/seaCustomerInfo?action=edit&customerId=" + id, "_blank");
        }
    }

    //读取cookies
    function getCookie(name) {
        var arr, reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
        if (arr = document.cookie.match(reg))
            return unescape(arr[2]);
        else
            return null;
    }

    //写cookies
    function setCookie(name, value) {
        $(".lastChoseCustomer").removeClass("lastChoseCustomer");
        $("#customerId_" + value).addClass("lastChoseCustomer");
        var Days = 30;
        var exp = new Date();
        exp.setTime(exp.getTime() + Days * 24 * 60 * 60 * 1000);
        document.cookie = name + "=" + escape(value) + ";expires=" + exp.toGMTString();
    }

    var curnet = "${sessionUser.cornet}";

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/customer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

</script>

</body>
</html>
