<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>客户回访纪录列表</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                客户回访纪录列表
            </li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span1">
            回访记录
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/customercallbacklog" method="get">
                <input type="hidden" id="customerId" name="customerId" value="${customerId}"/>
            </form>
        </div>
        <div class="span9">
        </div>
        <div class="span2">
            <shiro:hasPermission name="FUNC:ADDCALL">
                <button type="button" class="btn btn-default" onclick="addCallBack()">添加回访</button>
            </shiro:hasPermission>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
        </tr>
        </thead>
        <c:forEach items="${customerCallbackLogs}" var="customerCallbackLog">
            <tr>
                <td nowrap="nowrap" width="80%">
                    <c:if test="${null ne customerCallbackLog.content && '' ne customerCallbackLog.content}">
                        <c:out value="${customerCallbackLog.content}"/>
                    </c:if>
                    <c:if test="${null eq customerCallbackLog.content || '' eq customerCallbackLog.content}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap" width="10%">
                    <c:if test="${null ne customerCallbackLog.managerName && '' ne customerCallbackLog.managerName}">
                        <c:out value="${customerCallbackLog.managerName}"/>
                    </c:if>
                    <c:if test="${null eq customerCallbackLog.managerName || '' eq customerCallbackLog.managerName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap" width="10%">
                    <c:if test="${null ne customerCallbackLog.createTime && '' ne customerCallbackLog.createTime}">
                        <f:formatDate value='${customerCallbackLog.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq customerCallbackLog.createTime || '' eq customerCallbackLog.createTime}">
                        &nbsp;
                    </c:if>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    function setCallbackContent(template) {
        var content = $(template).text();
        $('.callback-content').val(content);
    }

    function addCallBack() {
        var buyIntention = "${buyIntention}";
        var callContentHtml = "";
        callContentHtml += "<div class='row-fluid'><div class='span5 control-group'>"
            + " <label class='control-label'>购房意向：</label>"
            + "<div class='controls'><select name='buyIntention' id='buyIntention'>"
            + "<option value=''";
        <c:if test="${null eq buyIntention or '' eq buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">请选择</option><option value='5'";
        <c:if test="${'5' eq buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">E</option><option value='4'";
        <c:if test="${'4' eq buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">D</option><option value='3'";
        <c:if test="${'3' eq buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">C</option><option value='2'";
        <c:if test="${'2' eq buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">B</option><option value='1'";
        <c:if test="${'1' eq buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">A</option>";
        callContentHtml += "</select></div></div></div>";
        callContentHtml += "<div class='row-fluid'><div class='span5 control-group'>"
            + " <label class='control-label'>回访内容：</label>";
        callContentHtml += "<textarea class='callback-content' cols='10' rows='5' style='margin: 0px 0px 10px; width: 436px; height: 70px;' id='callContent'></textarea>"
            + "</div></div>";

        callContentHtml += "<div style='margin-top: 10px;'>"
        callContentHtml += "<c:forEach items='${callbackTemplateList}' var='item'>";
        callContentHtml += "<button type='button' class='btn' style='margin: 5px' onclick='setCallbackContent(this)'>${item.content}</button>";
        callContentHtml += "</c:forEach>";
        callContentHtml += "</div>";

        callContentHtml += "<div style='margin-top: 10px;'>" + "<span>回访提醒：</span>";
        callContentHtml += "<input type='text' style='width: 200px;' autocomplete='off' class='datetime-picker span2 input-large' id='returnTime' date-language='zh-CN' date-format='yyyy-mm-dd hh:ii:ss' placeholder='/年/月/日'>";
        callContentHtml += "</div>";

        var isPeer = "${isPeer}";
        if (isPeer == 0) {
            callContentHtml += "<div class='row-fluid'><div>" + "<span>中介同行：</span>" + "<input type='radio' name='isPeer' value='0' checked>" + "否";
            callContentHtml += "<input style='margin-left: 20px;' type='radio' name='isPeer' value='1'>" + "是" + "</div></div>";
        } else if (isPeer == 1) {
            callContentHtml += "<div class='row-fluid'><div>" + "<span>中介同行：</span>" + "<input type='radio' name='isPeer' value='0'>" + "否";
            callContentHtml += "<input style='margin-left: 20px;' type='radio' name='isPeer' value='1' checked>" + "是" + "</div></div>";
        }

        House365Util.createModal("添加回访",
            callContentHtml, function () {
                var callContent = $("#callContent").val().replace(/(^\s*)|\s*$/g,'');
                var buyIntention = $("#buyIntention").val();
                var isPeer = $("input[name='isPeer']:checked").val();
                var customerId = $("#customerId").val();
                var returnTime = $("#returnTime").val();

                if (buyIntention == null || buyIntention == '') {
                    alert("请选择购房意向");
                    return false;
                }
                if (returnTime != null && returnTime != '') {
                    var date = new Date();
                    var date1 = new Date(returnTime);
                    if (date.getTime() > date1.getTime()) {
                        alert("回访提醒时间不能小于当前时间");
                        return false;
                    }
                }

                if (!callContent || callContent == "") {
                    alert("回访内容不能为空");
                    return false;
                } else if (callContent.length > 600) {
                    alert("不能超过600个字");
                    return false;
                } else if (buyIntention == 5) {
                    House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
                        $.ajax({
                            url: '${ctx}/customer/addCall',
                            data: {
                                "content": callContent,
                                "customerId": customerId,
                                "buyIntention": buyIntention
                            },
                            type: "GET",
                            success: function (data) {
                                if (data.result == '1') {
                                    window.location.reload();
                                } else {
                                    alert("操作失败，" + data.msg);
                                }
                            }
                        });
                        //更新客户是否中介同行状态
                        $.ajax({
                            url: '${ctx}/customermanagement/updatePeerAndTime',
                            contentType: 'application/json',
                            data: JSON.stringify({
                                id: customerId,
                                isPeer: isPeer,
                                buyIntention: buyIntention,
                                returnRemindTime: returnTime
                            }),
                            dataType: 'json',
                            type: "POST",
                            success: function (data) {
                                if (data.status == 0) {
                                    window.location.reload();
                                } else {
                                    alert(data.errorMessage);
                                }
                            }
                        });
                    });
                    return false;
                } else {
                    $.ajax({
                        url: '${ctx}/customer/addCall',
                        data: {
                            "content": callContent,
                            "customerId": customerId,
                            "buyIntention": buyIntention
                        },
                        type: "GET",
                        success: function (data) {
                            if (data.result == '1') {
                                window.location.reload();
                            } else {
                                alert("操作失败，" + data.msg);
                            }
                        }
                    });

                    //更新客户是否中介同行状态
                    $.ajax({
                        url: '${ctx}/customermanagement/updatePeerAndTime',
                        contentType: 'application/json',
                        data: JSON.stringify({
                            id: customerId,
                            isPeer: isPeer,
                            returnRemindTime: returnTime
                        }),
                        dataType: 'json',
                        type: "POST",
                        success: function (data) {
                            if (data.status == 0) {
                                window.location.reload();
                            } else {
                                alert(data.errorMessage);
                            }
                        }
                    });
                }
            });
    }
</script>
</body>
</html>
