<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "展开↓";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "收起↑";
    }
</style>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/customer/addNewCustomer"
      method="post">
    <input type="hidden" id="actSourceType" name="actSourceType" value="" />
    <input type="hidden" id="platMangerId" name="platMangerId" value="" />
    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li><a href="/house365-hgs-web/">首页</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    <%--<a href="/house365-hgs-web/customer/myCustomer">我的客户</a>--%>
                    <a href="/house365-hgs-web/customermanagement/myCustomerNew?type=&search_EQ_orderByTime=5">我的客户</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    客户信息
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    <span class="inline">新增</span>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span10 offset1">
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <input type="hidden" name="entity.customerType" value="1"/>
                    <input type="hidden" id="canCommit" name="canCommit" value=""/>
                    <div class="sectionTitle" style="height:30px;">
                        基本信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户姓名:<span style="color:red;">*</span></label>
                            <div class="controls">
                                <input type="text" id="entity_name"
                                       name="entity.name" class="required"
                                       value="${entity.name}"/>
                                <span style="color:red;"><form:errors path="customerVo.entity.name"/></span>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">手机号码:<span style="color:red;">*</span></label>
                            <div class="controls">
                                <span class="inline">
                                <input type="text" id="entity_phone" class="required"
                                       name="entity.phone" maxlength="11"
                                       value="${entity.phone}" onblur="checkCustomerPhone()"/>
                                </span>
                                <span style="color: red" id="phoneError"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">性别:</label>
                            <div class="controls">
                                <input type="radio" name="entity.sex" value="2" <c:if test="${entity.sex eq '2'}">
                                       checked</c:if>>未知
                                <input type="radio" name="entity.sex" value="1" <c:if test="${entity.sex eq '1'}">
                                       checked</c:if>>男
                                <input type="radio" name="entity.sex" value="0" <c:if test="${entity.sex eq '0'}">
                                       checked</c:if>>女
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">其他号码1:</label>
                            <div class="controls">
                                <input type="text" id="entity_bakPhone1"
                                       name="entity.bakPhone1" maxlength="11"
                                       value="${entity.bakPhone1}"/>
                                <span style="color: red"><form:errors path="customerVo.entity.bakPhone1"/></span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">跟踪状态:</label>
                            <div class="controls">
                                <select name="entity.traceStatus" id="traceStatus">
                                    <option value="1"
                                            <c:if test="${'1' eq entity.traceStatus}">selected="selected"</c:if>>
                                        有效
                                    </option>
                                    <option value="2"
                                            <c:if test="${'2' eq entity.traceStatus}">selected="selected"</c:if>>
                                        已购
                                    </option>
                                    <option value="3"
                                            <c:if test="${'3' eq entity.traceStatus}">selected="selected"</c:if>>
                                        我购
                                    </option>
                                    <option value="4"
                                            <c:if test="${'4' eq entity.traceStatus}">selected="selected"</c:if>>
                                        暂缓
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">活动来源：<span style="color: red">*</span></label>
                            <div class="controls">
                                <select name="entity.actSourceId" id="actSource" onchange="show_sub(this.options[this.options.selectedIndex].attributes[1].value)">
                                    <c:forEach items="${sources}" var="source">
                                        <option value="${source.id}" attr="${source.type}">${source.sourceName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">购房意向：<span style="color: red">*</span></label>
                            <div class="controls">
                                <select name="entity.buyIntention" id="buyIntention">
                                    <option value="">请选择</option>
                                    <option value="1">A</option>
                                    <option value="2">B</option>
                                    <option value="3">C</option>
                                    <option value="4">D</option>
                                </select>
                            </div>
                        </div>
                        <div id="platDiv" class="span5 control-group">
                            <label class="control-label">平台人员：<span style="color: red">*</span></label>
                            <div class="controls">
                                <select name="entity.managerId" id="plat" onchange="checkPlatPhone(this.options[this.options.selectedIndex].value)">
                                    <option value="">请选择</option>
                                    <c:forEach items="${platManagers}" var="platManager">
                                        <option value="${platManager.id}">${platManager.managerName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span9 control-group">
                            <label class="control-label">回访记录:<span style="color: red">*</span></label>
                            <div class="controls">
                                        <textarea class="span9" id="remark" name="entity.remark" rows="6"
                                                  maxlength="600"
                                                  placeholder="回访记录">${entity.remark}</textarea>
                                <span style="color: red"><form:errors path="customerVo.entity.remark"/></span>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <div class="portlet-header" style="margin-top: 20px;">
                <div class="operation-btn">
                    <input class="btn blue" type="button" onclick="commitForm()" value="保存"/>
                    <a href="${ctx}/customermanagement/myCustomerNew?type=waitCall&search_EQ_orderByTime=3" class="btn gray">返回</a>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
    $(function () {
        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });

        $('.header').click();
        document.getElementById("platDiv").style.display = "none"
    });

    function show_sub(sourceType){
        if("1" == sourceType){
            document.getElementById("platDiv").style.display = "block";
            $("#actSourceType").val("1");
        }else{
            document.getElementById("platDiv").style.display = "none";
            $("#actSourceType").val("0");
        }
    }

    function commitForm() {
        var phone = $("#entity_phone").val();
        var phone1 = $("#entity_bakPhone1").val();
        var entity_name = $("#entity_name").val();
        var actSource = $("#actSource").val();
        var buyIntention = $("#buyIntention").val();
        var platMangerId = $("#platMangerId").val();
        var actSourceType = $("#actSourceType").val();
        var remark = $("#remark").val().replace(/(^\s*)|\s*$/g, '');
        var canCommit = $("#canCommit").val();

        if (entity_name == 'null' || !entity_name || entity_name == "") {
            House365Util.createModal("提示", "请填写姓名", function () {
                $("#entity_name").focus();
            });
            return false;
        }
        if (actSource == 'null' || !actSource || actSource == "") {
            House365Util.createModal("提示", "请选择活动来源", function () {
                $("#actSource").focus();
            });
            return false;
        }

        if (buyIntention == 'null' || !buyIntention || buyIntention == "") {
            alert("请填写购房意向");
            return false;
        }

        if (remark == 'null' || !remark || remark == "") {
            alert("请填写回访记录");
            return false;
        }

        var city = "";
        $("#currentDept").find("option:selected").each(function () {
            city = $(this).val();
        });

        if ("1" == city) {
            House365Util.createModal("提示", "请切换到城市再添加客户信息", function () {
            });
            return false;
        }

        if (phone == "") {
            House365Util.createModal("提示", "请填写电话号码", function () {
                $("#entity_phone").focus();
            });
            return false;
        }
        if (phone != "" && !checkMobile(phone)) {
            House365Util.createModal("提示", "电话号码格式不正确", function () {
                $("#entity_phone").focus();
            });
            return false;
        }
        if (phone1 != "" && !checkMobile(phone1)) {
            House365Util.createModal("提示", "其他号码1格式不正确", function () {
                $("#entity_bakPhone1").focus();
            });
            return false;
        }

        if (actSourceType == '1' && (platMangerId == 'null' || !platMangerId || platMangerId == "")) {
            alert("请重新选择平台人员");
            return false;
        }

        if("1" ==canCommit && actSourceType == "1"){
            alert("该号码已添加,请勿重复操作");
            return false;
        }
//        var pmangerId = $("#platMangerId").val();
//        if(pmangerId != 'null' && pmangerId != "" && pmangerId){
//            checkPlatPhone(pmangerId);
//        }
//        var canCommit2 = $("#canCommit").val();
//        if("1" ==canCommit2){
//            alert("该号码已添加,请勿重复操作");
//            return false;
//        }
        $("#input_form").submit();
    }

    function checkMobile(val) {
        var pattern = /(^(([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)|(^0{0,1}1[3|4|5|6|7|8|9][0-9]{9}$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }

    }

    function checkCustomerPhone() {
        var phone = $("#entity_phone").val();
        if (!checkMobile(phone)) {
            $("#phoneError").text("手机号有误，请重填！");
            return false;
        }
        $("#canCommit").val("2");
        $.ajax({
            url: "${ctx}/customer/checkCustomerPhone",
            data: {
                customerPhone: phone
            },
            type: "get",
            success: function (data) {
                console.log(data);
                if (data.result === "0") {
                    $("#phoneError").text(data.msg);
//                    $("#canCommit").val("1")
                } else {
                    $("#phoneError").text("");
                }
            }
        });
        var actSourceType = $("#actSourceType").val();
        if (actSourceType == '1'){
            var platMangerId = $("#platMangerId").val();
            checkPlatPhone(platMangerId);
        }
    }

    function checkPlatPhone(platMangerId) {
        var phone = $("#entity_phone").val();
        if (!checkMobile(phone)) {
            $("#phoneError").text("手机号有误，请重填！");
            return false;
        }
        $("#platMangerId").val(platMangerId);
        $.ajax({
            url: "${ctx}/customer/checkCustomerPhone",
            data: {
                customerPhone: phone,
                platMangerId: platMangerId,
                sourceType: "2"
            },
            type: "get",
            success: function (data) {
                console.log(data);
                if (data.result === "0") {
                    $("#phoneError").text(data.msg);
                    $("#canCommit").val("1");
//                    $("#platMangerId").val("")
//                    var obj = document.getElementById("plat");
//                    for(var i=0;i<obj.length;i++){
////                        if(i==0){
////                            obj[i].selected=true;
////                        }else{
////                            obj[i].selected=false;
////                        }
//
//                    }
                } else {
                    $("#phoneError").text("");
                    $("#canCommit").val("2")
                }
            }
        });
    }
</script>

</body>

</html>
