<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>云迹拉取数据</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>客户管理
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>云迹拉取数据
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <form id="filterForm" name="filterForm" class="form-inline filterForm"
              action="${ctx}/cloudactivity/pullList" method="get">

            <div style="margin-top:10px;">
                活动名称：<input type="text" id="search_name" style="border: 1px solid #d5d5d5;" name="search_name"
                            value="${param['search_name']}"
                            class="m-wrap small" placeholder="活动名称">&nbsp;&nbsp;&nbsp;&nbsp;
                <a class="btn" onclick="btnSubmit();">搜索</a>
            </div>
            <div style="margin-left: 80%">
                <button type="button" class="btn btn-default" onclick="toAddCloud()">创建活动</button>
            </div>
        </form>

        <table class="table table-bordered table-advance table-hover">
            <tr class="info">
                <td width="100" style="text-align:center">序号</td>
                <td width="100" style="text-align:center">名称</td>
                <td width="100" style="text-align:center">总数</td>
                <td width="100" style="text-align:center">待派</td>
                <td width="100" style="text-align:center">已派</td>

                <td width="100" style="text-align:center">创建人</td>
                <td width="100" style="text-align:center">创建时间</td>
                <td width="100" style="text-align:center">操作</td>
            </tr>
            <c:if test="${not empty dataList}">
                <c:forEach items="${dataList}" var="item" varStatus="i">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${i.index+1}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.name}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.customerCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.waitCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.sentCount}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.createName}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.createTime && '' ne item.createTime}">
                                <f:formatDate value='${item.createTime}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                            <c:if test="${null eq item.createTime || '' eq item.createTime}">
                                -
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <button onclick="geDetail(${item.id})">详情</button>
                        </td>
                    </tr>
                </c:forEach>
            </c:if>
            <c:if test="${ empty dataList}">
                <tr>
                    <td colspan="15" style="text-align: center">暂未找到与条件相关的数据，请重新搜索</td>
                </tr>
            </c:if>

        </table>
        <div class="row${fluid}">
            <house365:pagination page="${page}"/>
        </div>
    </div>

</div>

<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>


<script type="text/javascript">

    function btnSubmit() {
        $('#filterForm').submit();
    }

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    function geDetail(id) {
        window.open("/house365-hgs-web/cloudcustomer/list/" + id, "_blank");
    }

    var toAddCloud = function () {
        window.open("/house365-hgs-web/cloudactivity/toAdd", "_blank");
    };

</script>
</body>
</html>
