<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>新增云迹活动</title>
</head>
<body>
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>

<form id="input_form" class="form-horizontal valid" action="${ctx}/cloudactivity/addCloud" method="post">
    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/cloudactivity/pullList">云迹拉取数据列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <span class="inline">新增</span>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="form-horizontal house365Page">

                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <h5>输入数据提取条件</h5>
                    </div>
                    <div class="alert">
                        <p>受CRM系统查询影响，单次获取的客户数量最多为999个，活动周期为30天</p>
                    </div>
                    <input id="total" name="total" type="hidden"/>
                    <input id="activeId" name="activeId" type="hidden"/>
                </div>

                <div class="house365Border">
                    <div class="sectionTitle">
                        <h5>基本信息</h5>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label"><span style="color: red">*</span>活动名称:</label>
                            <div class="controls">
                                <input type="text" class="span3" id="name" name="name"/>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="house365Border">
                    <div class="sectionTitle">
                        <h5>意向条件</h5>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">总价范围:</label>
                            <div class="controls">
                                <input type="text" id="totalPriceMin" name="entity.totalPriceMin"
                                       class="span3 number digits">
                                <input type="text" id="totalPriceMax" name="entity.totalPriceMax"
                                       class="span3 number digits ">(万元)
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">面积范围：</label>
                            <div class="controls">
                                <input type="text" id="areaMin" name="entity.areaMin"
                                       class="span3 number digits ">
                                <input type="text" id="areaMax" name="entity.areaMax"
                                       class="span3 number digits ">(㎡)
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">板块:</label>
                            <div class="controls">
                                <input name="entity.blockName" id="blockName" type="hidden" value="${entity.block}"/>
                                <select id="block" name="entity.block" class="selectpicker show-tick form-control"
                                        multiple data-live-search="false">
                                    <c:forEach items="${blocks}" var="block">
                                        <%--<option value="${block.dicValue}">${block.dicName}</option>--%>
                                        <option value="${block.dicName}">${block.dicName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">区域：</label>
                            <div class="controls">
                                <input name="entity.districtName" id="districtName" type="hidden"
                                       value="${entity.district}"/>
                                <select id="district" name="entity.district" class="selectpicker show-tick form-control"
                                        multiple data-live-search="false">
                                    <c:forEach items="${districts}" var="district">
                                        <%--<option value="${district.dicValue}">${district.dicName}</option>--%>
                                        <option value="${district.dicName}">${district.dicName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">物业类型:</label>
                            <div class="controls">
                                <input name="entity.channelName" id="channelName" type="hidden"
                                       value="${entity.channel}"/>
                                <select id="channel" name="entity.channel" onchange="setchannel()">
                                    <option value="">--请选择--</option>
                                    <c:forEach items="${fns:getDictList('crm_property_type')}" var="dict">
                                        <option value="${dict.dicValue}">${dict.dicName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="house365Border">
                    <div class="sectionTitle">
                        <h5>浏览轨迹条件</h5>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">浏览项目:</label>
                            <div class="controls">
                                <input type="hidden" id="projectId" name="projectId"/>
                                <input type="text" id="projectName" name="projectName" class=" span12"
                                       onclick="assignProject(500)"/>
                            </div>
                        </div>
                        <div class="span4 control-group">
                            <label class="control-label">访问时间:</label>
                            <div class="controls">
                                <input type="hidden" id="seeStartTime" name="seeStartTime"/>
                                <input type="hidden" id="seeEndTime" name="seeEndTime"/>
                                <input type="text" id="signTimeNew" name="signTimeNew" class="form-control span12">
                                <a href="javascript:void(0)" class="btn blue" onclick="cleanVisitTime()">
                                    清空
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <label class="control-label">浏览次数:</label>
                        <div class="controls">
                            <select id="seeCount" name="seeCount">
                                <option value="0" selected>--请选择--</option>
                                <option value="5">>5</option>
                                <option value="10">>10</option>
                                <option value="20">>20</option>
                                <option value="30">>30</option>
                            </select>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span1 control-group">
                        </div>
                        <div class="span6 control-group" style="margin-left: 50%;margin-top: 10px;">
                            <a href="javascript:void(0)" class="btn blue" onclick="checkForm()">
                                <i class="icon-save"></i>&nbsp;下一步
                            </a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

</form>

<div id="confirmDialog" style="display: none" title="">

</div>

<div id="loadingDialog" style="display: none;">
    <div class="progress" id="prog_out">
        <div class="bar" style="width: 0%;" id="prog_in"></div>
    </div>
    已导入<span id="complete">0</span>条
</div>

<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
<script src="${static_common }/script/jquery/bootstrap-select.min.js" type="text/javascript"></script>
<link rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.10.0/css/bootstrap-select.min.css">
<script href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.10.0/js/i18n/defaults-*.min.js"></script>
<script type="text/javascript">

    var $form = $("#input_form");

    function setchannel() {
        var name = $("#channel").find("option:selected").text();
        $("#channelName").val(name);
    }

    function cleanVisitTime() {
        $("#signTimeNew").val("");
        $("#seeStartTime").val("");
        $("#seeEndTime").val("");
        return false;
    }

    function doImport() {
        var total = $("#total").val();
        if(total == 0){
            alert("没有数据，请重新查询");
            return false;
        }
        $("#loadingDialog").dialog({
            dialogClass: "no-close",
            autoOpen: false,
            width: 1000,
            modal: true,
            show: {
                effect: "blind",
                duration: 100
            },
            hide: {
                effect: "explode",
                duration: 100
            }
        }).dialog("open");

        var sitv = setInterval(function () {
            var prog_url = "${ctx}/cloudactivity/getLoad/" + $("#activeId").val() + "/" + $("#total").val();
            $.getJSON(prog_url, function (res) {
                $('#prog_in').width(res.entity + '%'); //改变进度条进度，注意这里是内层的div，res是后台返回的进度
                $('#complete').text(res.total);
                if (res.entity == 100) {
                    $("#loadingDialog").dialog("close");
                    clearInterval(sitv);
                    $("#ui-id-1").text("加入成功");
                    $("#confirmDialog").text(res.total + "组数据已进入待派列表，其中" + res.paraMap.protectCount + "条数据处于保护未显示");
                    $("#confirmDialog").dialog({
                        dialogClass: "no-close",
                        autoOpen: false,
                        modal: true,
                        show: {
                            effect: "blind",
                            duration: 100
                        },
                        hide: {
                            effect: "explode",
                            duration: 100
                        },
                        buttons: [
                            {
                                text: "确认",
                                click: function () {
                                    $(this).dialog("close");
                                    window.open("/house365-hgs-web/cloudcustomer/list/" + $("#activeId").val(), "_self");
//                                    window.open("/house365-hgs-web/cloudcustomer/list/" + $("#activeId").val(), "_blank");
                                    return true;
                                }
                            }
                        ]
                    }).dialog("open");
                    // $(".ui-dialog-titlebar").hide();
                }
            });
        }, 900);

        $.ajax({
            url: "${ctx}/cloudactivity/import/" + $("#activeId").val(),
            type: "POST",
            async: true,
            data: $form.serialize(),
            success: function (response) {
            }
        });
    }

    function assignBuilding(maxCount) {
        House365Util.createRemoteModal("选择楼盘", "${ctx}/customer/assignBuilding?maxCount=" + maxCount
            + "&departmentNames=" + $("#buildingName").val() + "&departmentIds=" + $("#buildingId").val(), null, function () {
            var buildIds = "", buildNames = "";
            $("[name='buildId']").each(function () {
                buildIds = buildIds + $(this).val() + ",";
            });

            $("[name='buildName']").each(function () {
                buildNames = buildNames + $(this).val() + ",";
            });

            $("#buildingId").val(buildIds);
            $("#buildingName").val(buildNames);
            return true;
        });
    }

    function assignProject(maxCount) {
        House365Util.createRemoteModal("选择楼盘", "${ctx}/customer/assignBuildingNew?maxCount=" + maxCount
            + "&departmentNames=" + $("#projectName").val() + "&departmentIds=" + $("#projectId").val(), null, function () {
            var projectIds = "", projectNames = "";
            $("[name='prtId']").each(function () {
                projectIds = projectIds + $(this).val() + ",";
            });

            $("[name='prtName']").each(function () {
                projectNames = projectNames + $(this).val() + ",";
            });

            $("#projectId").val(projectIds);
            $("#projectName").val(projectNames);
            return true;
        });
    }

    function checkForm() {
        var name = $("#name").val();
        var seeStartTime = $("#seeStartTime").val();
        var seeEndTime = $("#seeEndTime").val();
        var seeCount = $("#seeCount").val();

        var projectName = $("#projectName").val();
        var totalPriceMin = parseInt($("#totalPriceMin").val(), 10) || 0;
        var totalPriceMax = parseInt($("#totalPriceMax").val(), 10) || 0;
        var areaMin = parseInt($("#areaMin").val(), 10) || 0;
        var areaMax = parseInt($("#areaMax").val(), 10) || 0;
        var block = $("#block").val();
        var district = $("#district").val();
        var channel = $("#channel").val();
        var blockName = $("#block").find("option:selected").text();
        var districtName = $("#district").find("option:selected").text();
        var channelName = $("#channelName").val();
        if (name == null || name == '') {
            alert("请填写活动名称");
            return;
        }
        if (seeStartTime == '') {
            alert("访问时间不能为空");
            return;
        }
        if (seeStartTime != '') {
            var projectId = $('#projectId').val();
            if (projectId == null || projectId == '') {
                alert("请填写浏览项目");
                return;
            }
            var date = new Date(new Date().getTime() - (1000 * 60 * 60 * 24 * 30));
            var seperator = "-";
            var year = date.getFullYear();
            var month = date.getMonth() + 1;
            var strDate = date.getDate();
            if (month >= 1 && month <= 9) {
                month = "0" + month;
            }
            if (strDate >= 0 && strDate <= 9) {
                strDate = "0" + strDate;
            }
            var dateNew = year + seperator + month + seperator + strDate + " 00:00:00";

            if (seeStartTime < dateNew) {
                alert("仅限近30天的数据");
                return;
            }
        }

        if ($("#totalPriceMin").val() && !$("#totalPriceMax").val()) {
            alert("请填写完整总价范围");
            return;
        }
        if ($("#areaMin").val() && !$("#areaMax").val()) {
            alert("请填写完整面积范围");
            return;
        }

        var data = {
            name: name,
            totalPriceMin: parseInt(totalPriceMin),
            totalPriceMax: parseInt(totalPriceMax),
            areaMin: parseInt(areaMin),
            areaMax: parseInt(areaMax),
            blockList: block,
            districtList: district,
            channel: channel,
            blockName: blockName,
            districtName: districtName,
            channelName: channelName,
            projectName: projectName,
            startTime: seeStartTime,
            endTime: seeEndTime,
            seeCount: parseInt(seeCount)
        };

        data = JSON.stringify(data);
        console.log(data);

        var validValue = $form.valid();

        if (validValue) {
            $.ajax({
                url: '${ctx}/cloudactivity/addCloud',
                type: 'POST',
                contentType: 'application/json',
                data: data,
                dataType: 'json',
                cache: false,
                success: function (response) {
                    if (0 == response.status) {
                        var total = response.data.total;
                        var activeId = response.data.id;
                        $("#total").val(total);
                        $("#activeId").val(activeId);
                        if (total > 1000) {
                            alert("数据量超过1000条，请缩小范围");
                            return false;
                        }
                        $("#confirmDialog").attr("title", "查询确认");
                        $("#confirmDialog").text("根据条件查询到" + total + "组客户数据\n" + "是否加入到活动中？");
                        $("#confirmDialog").dialog({
                            dialogClass: "no-close",
                            autoOpen: false,
                            width: 600,
                            height: 150,
                            modal: true,
                            show: {
                                effect: "blind",
                                duration: 100
                            },
                            hide: {
                                effect: "explode",
                                duration: 100
                            },
                            buttons: [
                                {
                                    text: "确认",
                                    click: function () {
                                        $("#confirmDialog").dialog("close");
                                        doImport();
                                        return true;
                                    }
                                },
                                {
                                    text: "取消",
                                    click: function () {
                                        $(this).dialog("close");
                                        return false;
                                    }
                                }
                            ]
                        }).dialog("open");

                    } else {
                        alert(response.errorMessage);
                        return false;
                    }
                }
            });
        }

    }

    $(document).ready(function () {
        var curDate;
        var limitDate = "${limitDate}";
        var maxDate;
        if (1 == limitDate) {
            curDate = moment(new Date().getTime() - 3 * 24 * 60 * 60 * 1000);
            maxDate = moment(new Date() - 3 * 24 * 60 * 60 * 1000);
        } else {
            curDate = new Date();
            maxDate = new Date(curDate.getTime() + 60 * 24 * 60 * 60 * 1000);
        }
        $.ajaxSetup({
            async: false
        });

        var options = {
            "showWeekNumbers": true,
            "showISOWeekNumbers": true,
            "startDate": curDate,
            "endDate": new Date(curDate + 60 * 24 * 60 * 60 * 1000),
            "maxDate": maxDate,
            "timePickerSeconds": true,
            "autoApply": true,
            "locale": {
                "direction": "ltr",
                "format": "YYYY年MM月DD日",
                "separator": " 至 ",
                "applyLabel": "确定",
                "cancelLabel": "取消",
                "fromLabel": "从",
                "toLabel": "至",
                "customRangeLabel": "Custom",
                "daysOfWeek": [
                    "日",
                    "一",
                    "二",
                    "三",
                    "四",
                    "五",
                    "六"
                ],
                "monthNames": [
                    "一月",
                    "二月",
                    "三月",
                    "四月",
                    "五月",
                    "六月",
                    "七月",
                    "八月",
                    "九月",
                    "十月",
                    "十一月",
                    "十二月"
                ],
                "firstDay": 1
            },
            weekendDis: false,
            "alwaysShowCalendars": true
        };

        $('#signTimeNew').daterangepicker(options, function (start, end, label) {
            $("#seeStartTime").val(start.format('YYYY-MM-DD 00:00:00'));
            $("#seeEndTime").val(end.format('YYYY-MM-DD 00:00:00'));
        });
        $("#signTimeNew").val("");
    });

</script>

</body>

</html>

