package com.house365.web.controller;

import com.house365.beans.entity.VersionEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.VersionVo;
import com.house365.web.system.controller.BaseController;
import com.house365.ws.beans.request.VersionListRequest;
import com.house365.ws.beans.request.VersionRequest;
import com.house365.ws.beans.response.VersionListResponse;
import com.house365.ws.beans.response.VersionResponse;
import com.house365.ws.interfaces.server.IVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Map;

@Controller
@RequestMapping("/appversion")
public class VersionController extends BaseController {

    Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IVersion version;

    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        Page page = new Page(8);
        if (null != number) {
            page.setCurrentPage(number);
        }
        VersionListRequest listRequest = new VersionListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        VersionListResponse response = version.getAppVersionList(listRequest);
        if (response.getObjectList() != null && !response.getObjectList().isEmpty()) {
            page.setRecords(response.getObjectList().size());
        }
        model.addAttribute("page", response.getPaging());
        model.addAttribute("versions", response.getObjectList());
        return getAutoUrl();
    }

    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model, HttpServletRequest httpRequest) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createVersion(@Valid VersionVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model, HttpServletRequest httpRequest) {
        VersionEntity entity = new VersionEntity();
        try {
            VersionRequest request = new VersionRequest();
            String forceUpdate = vo.getEntity().getForceUpdate();
            request.setEntity(vo.getEntity());
            VersionResponse response = version.addVersion(request);
//            return getAutoUrl("list");
            return "redirect:/appversion";
        } catch (Exception ex) {
            addErrorMessage(model, ex.getMessage());
            model.addAttribute("action", "create");
            return getAutoUrl("form");
        }

    }

    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id, HttpServletResponse httpResponse) {
        version.deleteVersionById(Integer.valueOf(id));
    }

}
