/**
 * Description: ProjectUser控制器
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 10:05:26
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.ProjectUserEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.ProjectUserVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.ProjectUserListRequest;
import com.house365.ws.beans.request.ProjectUserRequest;
import com.house365.ws.beans.response.ProjectUserListResponse;
import com.house365.ws.beans.response.ProjectUserResponse;
import com.house365.ws.interfaces.server.IProjectUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * ProjectUser控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/projectuser")
public class ProjectUserController extends BaseController {

    /**
     * 自动注入ProjectUserWS实现
     */
    @Autowired
    private IProjectUser projectUser;

    /**
     * 去新增ProjectUser
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增ProjectUser
     *
     * @param vo     ProjectUser页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createProjectUser(@Valid ProjectUserVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model) {
        ProjectUserEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                ProjectUserRequest request = new ProjectUserRequest();
                request.setEntity(entity);
                ProjectUserResponse response = projectUser
                        .addProjectUser(request);
                Integer id = response.getEntity().getId();
                return "redirect:/projectuser/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除ProjectUser
     *
     * @param id ProjectUser页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    projectUser.deleteProjectUserById(Integer.valueOf(ids[i]));
                }
            } else {
                projectUser.deleteProjectUserById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看ProjectUser
     *
     * @param id ProjectUser页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        ProjectUserResponse response = projectUser.getProjectUserById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改ProjectUser
     *
     * @param id ProjectUser页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        ProjectUserResponse response = projectUser
                .getProjectUserById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改ProjectUser
     *
     * @param vo     ProjectUser页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateProjectUser(@Valid ProjectUserVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model) {
        ProjectUserEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                ProjectUserRequest request = new ProjectUserRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                ProjectUserResponse rersponse = projectUser
                        .updateProjectUser(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/projectuser/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询ProjectUser
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(
                request, "search_");
        Page page = new Page(20);
        if (null != number) {
            page.setCurrentPage(number);
        }
        ProjectUserListRequest listRequest = new ProjectUserListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        ProjectUserListResponse response = projectUser.getProjectUserList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("projectUsers", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }
}
