/**
 * Description: EvaluateUserCustomerLog控制器
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-16 下午 18:38:35
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-16   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.DepartmentEntity;
import com.house365.beans.entity.DictionaryEntity;
import com.house365.beans.entity.EvaluateUserCustomerLogEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.EvaluateUserCustomerLogVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.SessionConstants;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.EvaluateUserCustomerLogListRequest;
import com.house365.ws.beans.request.EvaluateUserCustomerLogRequest;
import com.house365.ws.beans.response.DepartmentResponse;
import com.house365.ws.beans.response.EvaluateUserCustomerLogListResponse;
import com.house365.ws.beans.response.EvaluateUserCustomerLogResponse;
import com.house365.ws.interfaces.server.IDepartment;
import com.house365.ws.interfaces.server.IDictionary;
import com.house365.ws.interfaces.server.IEvaluateUserCustomerLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * EvaluateUserCustomerLog控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-16
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/evaluateusercustomerlog")
public class EvaluateUserCustomerLogController extends BaseController {

    /**
     * 自动注入EvaluateUserCustomerLogWS实现
     */
    @Autowired
    private IEvaluateUserCustomerLog evaluateUserCustomerLog;

    @Autowired
    private IDepartment department;

    @Autowired
    private IDictionary dictionary;

    /**
     * 去新增EvaluateUserCustomerLog
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增EvaluateUserCustomerLog
     *
     * @param vo     EvaluateUserCustomerLog页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createEvaluateUserCustomerLog(@Valid EvaluateUserCustomerLogVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model) {
        EvaluateUserCustomerLogEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                EvaluateUserCustomerLogRequest request = new EvaluateUserCustomerLogRequest();
                request.setEntity(entity);
                EvaluateUserCustomerLogResponse response = evaluateUserCustomerLog
                        .addEvaluateUserCustomerLog(request);
                Integer id = response.getEntity().getId();
                return "redirect:/evaluateusercustomerlog/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除EvaluateUserCustomerLog
     *
     * @param id EvaluateUserCustomerLog页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    evaluateUserCustomerLog.deleteEvaluateUserCustomerLogById(Integer.valueOf(ids[i]));
                }
            } else {
                evaluateUserCustomerLog.deleteEvaluateUserCustomerLogById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看EvaluateUserCustomerLog
     *
     * @param id EvaluateUserCustomerLog页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        EvaluateUserCustomerLogResponse response = evaluateUserCustomerLog
                .getEvaluateUserCustomerLogById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改EvaluateUserCustomerLog
     *
     * @param id EvaluateUserCustomerLog页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        EvaluateUserCustomerLogResponse response = evaluateUserCustomerLog
                .getEvaluateUserCustomerLogById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改EvaluateUserCustomerLog
     *
     * @param vo     EvaluateUserCustomerLog页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateEvaluateUserCustomerLog(@Valid EvaluateUserCustomerLogVo vo, BindingResult result,
                                                @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model) {
        EvaluateUserCustomerLogEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                EvaluateUserCustomerLogRequest request = new EvaluateUserCustomerLogRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                EvaluateUserCustomerLogResponse rersponse = evaluateUserCustomerLog
                        .updateEvaluateUserCustomerLog(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/evaluateusercustomerlog/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 去修改EvaluateUserCustomerLog
     *
     * @param id EvaluateUserCustomerLog页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "evaluate/{id}", method = {RequestMethod.GET})
    public String evaluateForm(@PathVariable(value = "id") Integer id, Model model) {
        EvaluateUserCustomerLogResponse response = evaluateUserCustomerLog
                .getEvaluateUserCustomerLogById(id);

        DictionaryEntity dictionaryEntity = dictionary.getByKey("evaluate_option");

        model.addAttribute("evaluateOptions", dictionaryEntity.getDicValue().split(","));
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("evaluate");
    }

    /**
     * 修改EvaluateUserCustomerLog
     *
     * @return 结果视图
     */
    @RequestMapping(value = "/evaluate/{id}", method = {RequestMethod.POST})
    @ResponseBody
    public Object evaluate(@PathVariable Integer id, Integer score, String content, String tags) {
        String commentContent = content;
        return evaluateUserCustomerLog
                .evaluateUser(id, score, commentContent, tags);
    }

    @RequestMapping(value = "/check", method = {RequestMethod.POST})
    @ResponseBody
    public Object check(HttpServletRequest request, Integer id, Integer checkStatus) {
        UserEntity userEntity = (UserEntity) request.getSession().getAttribute(SessionConstants.THREAD_USER_KEY);
        return evaluateUserCustomerLog.check(id, checkStatus, userEntity.getRealName());
    }

    /**
     * 查询EvaluateUserCustomerLog
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        DepartmentEntity departmentEntity = (DepartmentEntity) request.getSession().getAttribute(
                SessionConstants.SESSION_CURRNET_DEPT_KEY);
        String cityId = departmentEntity.getCityID();
        DepartmentResponse departmentResponse = department.getDepartmentById(Integer.valueOf(cityId));
        String cityCode = departmentResponse.getEntity().getDescripition();
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(
                request, "search_");

        if (searchParams.containsKey("GTE_evaluateTimeStart")) {
            searchParams.put("GTE_evaluateTimeStart", searchParams.get("GTE_evaluateTimeStart") + " 00:00:00");
        }
        if (searchParams.containsKey("LTE_evaluateTimeEnd")) {
            searchParams.put("LTE_evaluateTimeEnd", searchParams.get("LTE_evaluateTimeEnd") + " 23:59:59");
        }
        searchParams.put("EQ_city", cityCode);
        searchParams.put("EQ_isEvaluated", 1);
        searchParams.put("EQ_isDeleted", 0);
        Page page = new Page();
        if (null != number) {
            page.setCurrentPage(number);
        }
        EvaluateUserCustomerLogListRequest listRequest = new EvaluateUserCustomerLogListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        EvaluateUserCustomerLogListResponse response = evaluateUserCustomerLog.getEvaluateUserCustomerLogList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("evaluateUserCustomerLogs", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }
}
