package com.house365.web.controller;

import com.house365.beans.entity.RequestLoginEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.system.Page;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.AddressUtils;
import com.house365.web.util.SessionConstants;
import com.house365.ws.beans.request.AuthorizationRequest;
import com.house365.ws.beans.response.AuthorizationResponse;
import com.house365.ws.interfaces.server.IUser;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Map;

/**
 * 登陆授权请求管理
 */
@Controller
@RequestMapping("/authorization")
public class AuthorizationController extends BaseController {

    @Autowired
    private IUser user;

    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        UserEntity userEntity = (UserEntity) request.getSession().getAttribute(SessionConstants.THREAD_USER_KEY);
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
//        DepartmentEntity department = (DepartmentEntity) request.getSession().getAttribute(SESSION_CURRNET_DEPT_KEY);
        searchParams.put("EQ_userId", userEntity.getId());
        Page page = new Page(10);
        if (null != number) {
            page.setCurrentPage(number);
        }
        AuthorizationRequest listRequest = new AuthorizationRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        listRequest.setOrderColumn("loginTime");
        listRequest.setOrderMode("desc");
        AuthorizationResponse response = user.getAuthorizationList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("requestAuthorizations", response.getObjectList());
        model.addAttribute("searchParams", Servlets.encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }

    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ResponseBody
    public JSONObject authorization(@PathVariable Integer id,  Model model, HttpServletRequest request) {
        JSONObject jo = new JSONObject();
        //先确认是否请求失效
        RequestLoginEntity RequestLoginEntity = user.getRequestLoginInfoById(id);
        if(RequestLoginEntity != null){
            Date requestTime = RequestLoginEntity.getLoginTime();
            Date dateStr = new Date();
            long min1 = AddressUtils.getDatePoor(dateStr, requestTime);
            RequestLoginEntity entity = new RequestLoginEntity();
            if(min1>10){
                entity.setStatus("2");
                entity.setId(id);
            }else{
                entity.setStatus("1");
                entity.setId(id);
            }
            user.authorizationById(entity);
        }
        jo.put("RESULTFLAG", "1");
        return jo;
    }


}
