package com.house365.beans.vo;

import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.Length;

/**
 * <p>Title: 微信用职员模型</p>
 * <p>Description: </p>
 * <p>Date: 2017/3/9</p>
 *
 * @author XN
 * @version 1.0
 */
public class WechatUserVo extends DomainObject {

    private String name;

    private String realName;

    private String mobile;

    /**
     * 部门编号
     */

    private Integer deptId;

    /**
     * 部门名称
     */
    private String deptName;

    /**
     * 1男 2女
     */
    private String gender;

    /**
     * 关注状态: 1=已关注，2=已禁用，4=未关注
     */

    private Integer status;

    /**
     * 1启用 0冻结
     */

    private Boolean enabled;

    public WechatUserVo(
        Integer id, String name, String realName, String mobile, Integer deptId, String deptName, String gender,
        Integer status, Boolean enabled
    ) {
        super(id);
        this.name = name;
        this.realName = realName;
        this.mobile = mobile;
        this.deptId = deptId;
        this.deptName = deptName;
        this.gender = gender;
        this.status = status;
        this.enabled = enabled;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Integer getDeptId() {
        return deptId;
    }

    public void setDeptId(Integer deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        if (!super.equals(o))
            return false;

        WechatUserVo that = (WechatUserVo) o;

        if (name != null ? !name.equals(that.name) : that.name != null)
            return false;
        if (realName != null ? !realName.equals(that.realName) : that.realName != null)
            return false;
        if (mobile != null ? !mobile.equals(that.mobile) : that.mobile != null)
            return false;
        if (deptId != null ? !deptId.equals(that.deptId) : that.deptId != null)
            return false;
        if (deptName != null ? !deptName.equals(that.deptName) : that.deptName != null)
            return false;
        if (gender != null ? !gender.equals(that.gender) : that.gender != null)
            return false;
        if (status != null ? !status.equals(that.status) : that.status != null)
            return false;
        if (enabled != null ? !enabled.equals(that.enabled) : that.enabled != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (realName != null ? realName.hashCode() : 0);
        result = 31 * result + (mobile != null ? mobile.hashCode() : 0);
        result = 31 * result + (deptId != null ? deptId.hashCode() : 0);
        result = 31 * result + (deptName != null ? deptName.hashCode() : 0);
        result = 31 * result + (gender != null ? gender.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (enabled != null ? enabled.hashCode() : 0);
        return result;
    }
}
