/**
 * Description: 角色权限关联页面表单对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-14 下午 17:27:23
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.house365.beans.entity.UserRoleEntity;

/**
 * 角色权限关联页面表单对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public class UserRoleVo{
	/**
	 * 角色权限关联实体
	 */
    @NotNull
    @Valid
	private UserRoleEntity entity;
	

	/**
	 * 设置角色权限关联实体
	 * @param entity 角色权限关联实体
	 */
	public void setEntity(UserRoleEntity entity) {
		this.entity = entity;
	}

	/**
	 * 获取角色权限关联实体
	 * @return 角色权限关联实体
	 */
	public UserRoleEntity getEntity() {
		return this.entity;
	}
}