/**
 * Description: 直销人员楼盘推荐数据库实体/领域对象
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-02-06 下午 12:17:46
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-02-06   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 直销人员楼盘推荐数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-02-06
 * @see
 * @since 1.0
 */
public class UserProjectRecommendEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    /**
     * 直销人员id
     */
    private Integer userId;

    /**
     * 直销人员名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String userName;

    /**
     * 楼盘id
     */
    private Integer projectId;

    /**
     * 楼盘名称
     */
    @Length(max = 300, message = "长度需要大于0且小于300")
    private String projectName;

    /**
     * 推荐理由
     */
    @Length(max = 1500, message = "长度需要大于0且小于1500")
    private String recommendReason;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最后一次修改时间
     */
    private Date updateTime;

    private Integer del;

    public Integer getDel() {
        return del;
    }

    public void setDel(Integer del) {
        this.del = del;
    }

    /**
     * 删除标记 0：未删除；1：已删除；
     */
    private Integer isDeleted;

    /**
     * 物业类型 1住宅2写字楼3别墅4商业5公寓
     */
    private Integer channel;

    /**
     * 城市
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String city;

    private String updateTimeDisplay;

    private String createTimeDisplay;

    public String getCreateTimeDisplay() {
        return createTimeDisplay;
    }

    public void setCreateTimeDisplay(String createTimeDisplay) {
        this.createTimeDisplay = createTimeDisplay;
    }


    public String getUpdateTimeDisplay() {
        return updateTimeDisplay;
    }

    public void setUpdateTimeDisplay(String updateTimeDisplay) {
        this.updateTimeDisplay = updateTimeDisplay;
    }

    /**
     * 获取直销人员id
     * @return 直销人员id
     */
    public Integer getUserId() {
        return this.userId;
    }

    /**
     * 设置直销人员id
     *
     * @param userId 直销人员id
     */
    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    /**
     * 获取直销人员名称
     * @return 直销人员名称
     */
    public String getUserName() {
        return this.userName;
    }

    /**
     * 设置直销人员名称
     * @param userName 直销人员名称
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取楼盘id
     * @return 楼盘id
     */
    public Integer getProjectId() {
        return this.projectId;
    }

    /**
     * 设置楼盘id
     *
     * @param projectId 楼盘id
     */
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取楼盘名称
     * @return 楼盘名称
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * 设置楼盘名称
     * @param projectName 楼盘名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 获取推荐理由
     * @return 推荐理由
     */
    public String getRecommendReason() {
        return this.recommendReason;
    }

    /**
     * 设置推荐理由
     *
     * @param recommendReason 推荐理由
     */
    public void setRecommendReason(String recommendReason) {
        this.recommendReason = recommendReason;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置最后一次修改时间字符串格式
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后一次修改时间
     *
     * @return 最后一次修改时间
     */
    public Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置最后一次修改时间
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取删除标记 0：未删除；1：已删除；
     *
     * @return 删除标记 0：未删除；1：已删除；
     */
    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    /**
     * 设置删除标记 0：未删除；1：已删除；
     * @param isDeleted 删除标记 0：未删除；1：已删除；
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * 获取物业类型 1住宅2写字楼3别墅4商业5公寓
     * @return 物业类型 1住宅2写字楼3别墅4商业5公寓
     */
    public Integer getChannel() {
        return this.channel;
    }

    /**
     * 设置物业类型 1住宅2写字楼3别墅4商业5公寓
     *
     * @param channel 物业类型 1住宅2写字楼3别墅4商业5公寓
     */
    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    /**
     * 获取城市
     * @return 城市
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置城市
     *
     * @param city 城市
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("UserId", getUserId())
                .append("UserName", getUserName())
                .append("ProjectId", getProjectId())
                .append("ProjectName", getProjectName())
                .append("RecommendReason", getRecommendReason())
                .append("CreateTime", getCreateTime())
                .append("UpdateTime", getUpdateTime())
                .append("createTimeDisplay", getCreateTimeDisplay())
                .append("updateTimeDisplay", getUpdateTimeDisplay())
                .append("IsDeleted", getIsDeleted())
                .append("Channel", getChannel())
                .append("City", getCity())
                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UserProjectRecommendEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        UserProjectRecommendEntity other = (UserProjectRecommendEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

