/**
 * Description: ReportChannelDepartRel数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 上午 10:14:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotNull;

/**
 * ReportChannelDepartRel数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public class ReportChannelDepartRelEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * channelId
     */
    @NotNull
    private Integer channelId;

    /**
     * departId
     */
    @NotNull
    private Integer departId;

    //columns END


    /**
     * 设置channelId
     * @param channelId channelId
     */
    public void setChannelId(Integer channelId) {
        this.channelId = channelId;
    }

    /**
     * 获取channelId
     * @return channelId
     */
    public Integer getChannelId() {
        return this.channelId;
    }

    /**
     * 设置departId
     * @param departId departId
     */
    public void setDepartId(Integer departId) {
        this.departId = departId;
    }

    /**
     * 获取departId
     * @return departId
     */
    public Integer getDepartId() {
        return this.departId;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("ChannelId", getChannelId())
                .append("DepartId", getDepartId())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ReportChannelDepartRelEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ReportChannelDepartRelEntity other = (ReportChannelDepartRelEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

