/**
 * Description: ProjectSourceStatistics数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-17 下午 14:59:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * ProjectSourceStatistics数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-17
 * @see
 * @since 1.0
 */
public class ProjectSourceStatisticsEntity extends StatisticObject {

    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 项目ID
     */
    private Integer projectId;

    /**
     * 项目名称
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String projectName;

    /**
     * 客户状态
     */

    private Integer customerStatus;

    /**
     * 客户数量
     */
    private Integer customerNum;

    /**
     * 来源ID
     */
    private Integer sourceId;

    /**
     * 来源名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String sourceName;

    /**
     * 城市编码
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String city;

    /**
     * 城市名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityName;

    /**
     * 环比
     */
    private Double dayBaseRatio;

    //projectid 类型 1部门2职员3项目
    private String objectType;

    /**
     * 创建时间
     */
    private Date createTime;

    //columns END

    public String getObjectType() {
        return objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    /**
     * 设置项目ID
     *
     * @param projectId 项目ID
     */
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取项目ID
     *
     * @return 项目ID
     */
    public Integer getProjectId() {
        return this.projectId;
    }

    /**
     * 设置项目名称
     *
     * @param projectName 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 获取项目名称
     *
     * @return 项目名称
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * 设置客户状态
     *
     * @param customerStatus 客户状态
     */
    public void setCustomerStatus(Integer customerStatus) {
        this.customerStatus = customerStatus;
    }

    /**
     * 获取客户状态
     *
     * @return 客户状态
     */
    public Integer getCustomerStatus() {
        return this.customerStatus;
    }

    /**
     * 设置客户数量
     *
     * @param customerNum 客户数量
     */
    public void setCustomerNum(Integer customerNum) {
        this.customerNum = customerNum;
    }

    /**
     * 获取客户数量
     *
     * @return 客户数量
     */
    public Integer getCustomerNum() {
        return this.customerNum;
    }

    /**
     * 设置来源ID
     *
     * @param sourceId 来源ID
     */
    public void setSourceId(Integer sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * 获取来源ID
     *
     * @return 来源ID
     */
    public Integer getSourceId() {
        return this.sourceId;
    }

    /**
     * 设置来源名称
     *
     * @param sourceName 来源名称
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    /**
     * 获取来源名称
     *
     * @return 来源名称
     */
    public String getSourceName() {
        return this.sourceName;
    }

    /**
     * 设置城市编码
     *
     * @param city 城市编码
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 获取城市编码
     *
     * @return 城市编码
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置城市名称
     *
     * @param cityName 城市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取城市名称
     *
     * @return 城市名称
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置环比
     *
     * @param dayBaseRatio 环比
     */
    public void setDayBaseRatio(Double dayBaseRatio) {
        this.dayBaseRatio = dayBaseRatio;
    }

    /**
     * 获取环比
     *
     * @return 环比
     */
    public Double getDayBaseRatio() {
        return this.dayBaseRatio;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("ProjectId",
                getProjectId()).append(
                "ProjectName", getProjectName()).append("CustomerStatus", getCustomerStatus()).append("CustomerNum",
                getCustomerNum()).append(
                "SourceId", getSourceId()).append("SourceName", getSourceName()).append("City", getCity()).append(
                "CityName", getCityName()).append("DayBaseRatio", getDayBaseRatio()).append("CreateTime",
                getCreateTime()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProjectSourceStatisticsEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ProjectSourceStatisticsEntity other = (ProjectSourceStatisticsEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

