package com.house365.beans.entity;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class PermissionTreeEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private boolean root;
    private PermissionEntity entity;
    private WeChatPermissionEntity weChatEntity;
    private List<PermissionTreeEntity> childs;
    private List<PermissionTreeEntity> weChilds;

    public PermissionTreeEntity() {
    }

    public PermissionTreeEntity(boolean root) {
        this.root = root;
    }

    public PermissionTreeEntity(PermissionEntity permissionEntity, boolean root) {
        this.root = root;
        this.entity = permissionEntity;
    }

    public void add(PermissionEntity permissionEntity) {
        if (entity.getId().intValue() == permissionEntity.getParentId().intValue()) {
            if (childs == null) {
                childs = new LinkedList<PermissionTreeEntity>();
            }
            childs.add(new PermissionTreeEntity(permissionEntity, false));
        } else if (childs != null) {
            for (PermissionTreeEntity child : childs) {
                if (child.getEntity().getId().intValue() == permissionEntity.getParentId().intValue()) {
                    child.add(permissionEntity);
                }
            }
        }
    }

    public void addWeEntity(WeChatPermissionEntity permissionEntity) {
        if (weChatEntity.getId().intValue() == permissionEntity.getParentId().intValue()) {
            if (weChilds == null) {
                weChilds = new LinkedList<PermissionTreeEntity>();
            }
            PermissionTreeEntity wee = new PermissionTreeEntity(permissionEntity, false);
            wee.setWeChatEntity(permissionEntity);
            weChilds.add(wee);
        } else if (weChilds != null) {
            for (PermissionTreeEntity child : weChilds) {
                if (child.getEntity().getId().intValue() == permissionEntity.getParentId().intValue()) {
                    child.addWeEntity(permissionEntity);
                }
            }
        }
    }

    public List<PermissionEntity> toList() {
        List<PermissionEntity> list = new LinkedList<PermissionEntity>();
        if (root) {
            if (childs != null) {
                for (PermissionTreeEntity child : childs) {
                    list.addAll(child.toList());
                }
            }
            return list;
        } else {
            list.add(entity);
            if (childs != null) {
                for (PermissionTreeEntity child : childs) {
                    list.addAll(child.toList());
                }
            }
            return list;
        }
    }

    public List<PermissionEntity> toShowList() {
        List<PermissionEntity> list = new LinkedList<PermissionEntity>();
        if (root) {
            if (childs != null) {
                for (PermissionTreeEntity child : childs) {
                    list.addAll(child.toShowList());
                }
            }
            return list;
        } else {
            if (childs == null && this.getEntity().getHierarchy() < 1) {
                return list;
            }
            list.add(entity);
            if (childs != null) {
                for (PermissionTreeEntity child : childs) {
                    list.addAll(child.toShowList());
                }
            }
            return list;
        }
    }

    public List<WeChatPermissionEntity> toWechatShowList() {
        List<WeChatPermissionEntity> list = new LinkedList<>();
        if (root) {
            if (weChilds != null) {
                for (PermissionTreeEntity child : weChilds) {
                    list.addAll(child.toWechatShowList());
                }
            }
            return list;
        } else {
            if (weChilds == null && this.getEntity().getHierarchy() < 1) {
                return list;
            }
            list.add(weChatEntity);
            if (weChilds != null) {
                for (PermissionTreeEntity child : weChilds) {
                    list.addAll(child.toWechatShowList());
                }
            }
            return list;
        }
    }

    public boolean isRoot() {
        return root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public PermissionEntity getEntity() {
        return entity;
    }

    public void setEntity(PermissionEntity entity) {
        this.entity = entity;
    }

    public WeChatPermissionEntity getWeChatEntity() {
        return weChatEntity;
    }

    public void setWeChatEntity(WeChatPermissionEntity weChatEntity) {
        this.weChatEntity = weChatEntity;
    }

    public List<PermissionTreeEntity> getChilds() {
        return childs;
    }

    public void setChilds(List<PermissionTreeEntity> childs) {
        this.childs = childs;
    }

}
