/**
 * Description: MarketBuildingRel数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:20:56
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * MarketBuildingRel数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public class MarketBuildingRelEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 楼盘ID
     */

    private Integer buildingId;

    /**
     * activeId
     */
    private Integer activeId;

    /**
     * 设置楼盘ID
     *
     * @param buildingId 楼盘ID
     */
    public void setBuildingId(Integer buildingId) {
        this.buildingId = buildingId;
    }

    /**
     * 获取楼盘ID
     *
     * @return 楼盘ID
     */
    public Integer getBuildingId() {
        return this.buildingId;
    }

    /**
     * 设置activeId
     *
     * @param activeId activeId
     */
    public void setActiveId(Integer activeId) {
        this.activeId = activeId;
    }

    /**
     * 获取activeId
     *
     * @return activeId
     */
    public Integer getActiveId() {
        return this.activeId;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("BuildingId", getBuildingId())
                .append("ActiveId", getActiveId())
                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MarketBuildingRelEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MarketBuildingRelEntity other = (MarketBuildingRelEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

