package com.house365.tags;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import org.apache.commons.lang3.StringUtils;

import com.house365.beans.system.DomainObject;


/**
 * 级联下拉列表标签抽象类
 *
 * @author duhui
 */
public abstract class AbstractCascadeSelectTag<T extends DomainObject> extends AbstractDomainObjectSelectTag<T> {

    /**
     */
    private static final long serialVersionUID = 1L;

    public AbstractCascadeSelectTag() {
        super.setClazz("sw-gank");
    }

    /**
     * 父下拉列表取值
     */
    private String parentValue;

    /**
     * 数据获取URL
     */
    private String gankUrl;

    /**
     * 子下拉列表选择器
     */
    private String childSel;

    /**
     * 扩展属性 <br>
     * 格式为"属性名1:属性值1;属性名2:属性值2;..."<br>
     * 例如:data-a:abc;data-b:cba
     */
    private String extAttributes;

    @Override
    protected void appendExtAttribute() {
        Map<String, String> extAttributeMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank(extAttributes)) {
            StringTokenizer tokenizer = new StringTokenizer(extAttributes, ";");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                String[] element = token.split(":");
                if (2 == element.length) {
                    extAttributeMap.put(element[0], element[1]);
                } else if (1 == element.length) {
                    extAttributeMap.put(element[0], "");
                }
            }
        }
        if (StringUtils.isNotBlank(parentValue)) {
            extAttributeMap.put("parentValue", parentValue);
        }
        if (StringUtils.isNotBlank(gankUrl)) {
            extAttributeMap.put("gankUrl", gankUrl);
        }
        if (StringUtils.isNotBlank(childSel)) {
            extAttributeMap.put("childSel", childSel);
        }
        addSelectAttributeMap(extAttributeMap);
    }

    /**
     * 获取父下拉列表取值
     * 
     * @return 父下拉列表取值
     */
    public String getParentValue() {
        return parentValue;
    }

    /**
     * 设置父下拉列表取值
     * 
     * @param parentValue 父下拉列表取值
     */
    public void setParentValue(String parentValue) {
        this.parentValue = parentValue;
    }

    /**
     * 获取数据获取URL
     * 
     * @return 数据获取URL
     */
    public String getGankUrl() {
        return gankUrl;
    }

    /**
     * 设置数据获取URL
     * 
     * @param gankUrl 数据获取URL
     */
    public void setGankUrl(String gankUrl) {
        this.gankUrl = gankUrl;
    }

    /**
     * 获取子下拉列表选择器
     * 
     * @return 子下拉列表选择器
     */
    public String getChildSel() {
        return childSel;
    }

    /**
     * 设置子下拉列表选择器
     * 
     * @param childSel 子下拉列表选择器
     */
    public void setChildSel(String childSel) {
        this.childSel = childSel;
    }

    /**
     * 获取扩展属性
     * 
     * @return 扩展属性
     */
    public String getExtAttributes() {
        return extAttributes;
    }

    /**
     * 设置扩展属性
     * 
     * @param extAttributes 扩展属性
     */
    public void setExtAttributes(String extAttributes) {
        this.extAttributes = extAttributes;
    }

    @Override
    public void setClazz(String clazz) {
        super.setClazz(" sw-gank " + clazz);
    }
}
